/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.command;

import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.model.BMotionGuide;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;

public class MoveGuideCommand
extends Command {
    private int pDelta;
    private BMotionGuide guide;

    public MoveGuideCommand(BMotionGuide guide, int positionDelta) {
        super("Move Guide");
        this.guide = guide;
        this.pDelta = positionDelta;
    }

    public void execute() {
        this.guide.setPosition(this.guide.getPosition() + this.pDelta);
        for (BControl part : this.guide.getParts()) {
            Point location = part.getLocation().getCopy();
            if (this.guide.isHorizontal()) {
                location.y += this.pDelta;
            } else {
                location.x += this.pDelta;
            }
            part.setLocation(location);
        }
    }

    public void undo() {
        this.guide.setPosition(this.guide.getPosition() - this.pDelta);
        for (BControl part : this.guide.getParts()) {
            Point location = part.getLocation().getCopy();
            if (this.guide.isHorizontal()) {
                location.y -= this.pDelta;
            } else {
                location.x -= this.pDelta;
            }
            part.setLocation(location);
        }
    }
}

