/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.action;

import de.bmotionstudio.gef.editor.BMotionEditorPlugin;
import de.bmotionstudio.gef.editor.action.YesToAllMessageDialog;
import de.bmotionstudio.gef.editor.internal.BMotionStudioRodinFile;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.part.FileEditorInput;

public class ActionCollection {
    public static Action getOpenAction(final ICommonActionExtensionSite site) {
        Action doubleClickAction = new Action("Open"){

            public void run() {
                ISelection selection = site.getStructuredViewer().getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof BMotionStudioRodinFile) {
                    BMotionStudioRodinFile file = (BMotionStudioRodinFile)obj;
                    IResource resource = file.getResource();
                    IFile ifile = resource.getProject().getFile(resource.getName());
                    try {
                        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(resource.getName());
                        BMotionEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(ifile), desc.getId());
                    }
                    catch (PartInitException e) {
                        MessageDialog.openError(null, null, (String)"Error open Editor");
                        BMotionEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "de.bmotionstudio.gef.editor", "Error open Editor", (Throwable)e));
                    }
                }
            }
        };
        return doubleClickAction;
    }

    public static Action getDeleteAction(final ICommonActionExtensionSite site) {
        Action deleteAction = new Action(){

            public void run() {
                if (!site.getStructuredViewer().getSelection().isEmpty()) {
                    ArrayList<BMotionStudioRodinFile> set = new ArrayList<BMotionStudioRodinFile>();
                    IStructuredSelection ssel = (IStructuredSelection)site.getStructuredViewer().getSelection();
                    for (Object obj : ssel) {
                        if (!(obj instanceof BMotionStudioRodinFile)) continue;
                        BMotionStudioRodinFile elem = (BMotionStudioRodinFile)obj;
                        set.add(elem);
                    }
                    int answer = YesToAllMessageDialog.YES;
                    for (BMotionStudioRodinFile element : set) {
                        if (answer != YesToAllMessageDialog.YES_TO_ALL) {
                            answer = YesToAllMessageDialog.openYesNoToAllQuestion(site.getViewSite().getShell(), "Confirm File Delete", "Are you sure you want to delete file '" + element.getResource().getName() + "' in project '" + element.getResource().getProject().getName() + "' ?");
                        }
                        if (answer == YesToAllMessageDialog.NO_TO_ALL || answer == YesToAllMessageDialog.CANCEL) break;
                        if (answer == YesToAllMessageDialog.NO) continue;
                        try {
                            ActionCollection.closeOpenedEditor(element);
                            element.getResource().delete(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (PartInitException partInitException) {
                            MessageDialog.openError(null, (String)"Error", (String)"Could not delete file");
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
        deleteAction.setText("&Delete");
        deleteAction.setToolTipText("Delete these elements");
        deleteAction.setImageDescriptor(BMotionEditorPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/etool16/delete_edit.gif"));
        return deleteAction;
    }

    static void closeOpenedEditor(BMotionStudioRodinFile file) throws PartInitException {
        IEditorReference[] editorReferences = BMotionEditorPlugin.getActivePage().getEditorReferences();
        int j = 0;
        while (j < editorReferences.length) {
            IFile inputFile = (IFile)editorReferences[j].getEditorInput().getAdapter(IFile.class);
            if (file.getResource().equals((Object)inputFile)) {
                IEditorPart editor = editorReferences[j].getEditor(true);
                IWorkbenchPage page = BMotionEditorPlugin.getActivePage();
                page.closeEditor(editor, false);
            }
            ++j;
        }
    }
}

