/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor;

import de.bmotionstudio.gef.editor.BControlCreationFactory;
import de.bmotionstudio.gef.editor.BMotionStudioImage;
import de.bmotionstudio.gef.editor.IBControlService;
import de.bmotionstudio.gef.editor.IInstallPaletteEntry;
import de.bmotionstudio.gef.editor.model.BConnection;
import de.bmotionstudio.gef.editor.model.Visualization;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteToolbar;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;

public class EditorPaletteFactory {
    private HashMap<String, PaletteDrawer> groupMap = new HashMap();

    public PaletteRoot createPalette(Visualization visualization) {
        PaletteRoot palette = new PaletteRoot();
        palette.add((PaletteEntry)this.createToolsGroup(palette, visualization));
        this.createControls(palette, visualization);
        this.createFromExtension(palette, visualization);
        return palette;
    }

    private void createFromExtension(PaletteRoot palette, Visualization visualization) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("de.bmotionstudio.gef.editor.paletteEntry");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if ("entry".equals(configurationElement.getName())) {
                    try {
                        IInstallPaletteEntry entry = (IInstallPaletteEntry)configurationElement.createExecutableExtension("class");
                        entry.installPaletteEntry(palette, this.groupMap);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void createControls(PaletteRoot palette, Visualization visualization) {
        String groupID;
        IConfigurationElement configurationElement;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IExtension extension;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("de.bmotionstudio.gef.editor.control");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n3 = iExtensionArray.length;
        int n4 = 0;
        while (n4 < n3) {
            extension = iExtensionArray[n4];
            iConfigurationElementArray = extension.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                configurationElement = iConfigurationElementArray[n];
                if ("group".equals(configurationElement.getName())) {
                    groupID = configurationElement.getAttribute("id");
                    String groupName = configurationElement.getAttribute("name");
                    PaletteDrawer componentsDrawer = new PaletteDrawer(groupName);
                    if (!this.groupMap.containsKey(groupID)) {
                        this.groupMap.put(groupID, componentsDrawer);
                    }
                }
                ++n;
            }
            ++n4;
        }
        iExtensionArray = extensionPoint.getExtensions();
        n3 = iExtensionArray.length;
        n4 = 0;
        while (n4 < n3) {
            extension = iExtensionArray[n4];
            iConfigurationElementArray = extension.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                PaletteDrawer groupDrawer;
                configurationElement = iConfigurationElementArray[n];
                if ("control".equals(configurationElement.getName()) && (groupDrawer = this.groupMap.get(groupID = configurationElement.getAttribute("groupid"))) != null) {
                    try {
                        ToolEntry toolEntry;
                        IBControlService service = (IBControlService)configurationElement.createExecutableExtension("service");
                        if (service.showInPalette() && (toolEntry = service.createToolEntry(visualization, configurationElement)) != null) {
                            groupDrawer.add((PaletteEntry)toolEntry);
                        }
                    }
                    catch (CoreException coreException) {}
                }
                ++n;
            }
            ++n4;
        }
        for (Map.Entry<String, PaletteDrawer> entry : this.groupMap.entrySet()) {
            if (entry.getValue().getChildren().size() <= 0) continue;
            palette.add((PaletteEntry)entry.getValue());
        }
    }

    private PaletteContainer createToolsGroup(PaletteRoot palette, Visualization visualization) {
        PaletteToolbar toolbar = new PaletteToolbar("Tools");
        PanningSelectionToolEntry tool = new PanningSelectionToolEntry();
        toolbar.add((PaletteEntry)tool);
        palette.setDefaultEntry((ToolEntry)tool);
        toolbar.add((PaletteEntry)new MarqueeToolEntry());
        toolbar.add((PaletteEntry)new ConnectionCreationToolEntry("Connection", "Universal Connector", (CreationFactory)new BControlCreationFactory(BConnection.TYPE, visualization), BMotionStudioImage.getImageDescriptor("icons/icon_connection16.gif"), BMotionStudioImage.getImageDescriptor("icons/icon_connection24.gif")));
        return toolbar;
    }
}

