/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import de.bmotionstudio.gef.editor.BMotionStudioEditor;
import de.bmotionstudio.gef.editor.BMotionStudioEditorPage;
import de.bmotionstudio.gef.editor.internal.BControlListConverter;
import de.bmotionstudio.gef.editor.model.BConnection;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.model.BControlList;
import de.bmotionstudio.gef.editor.model.BMotionGuide;
import de.bmotionstudio.gef.editor.model.Visualization;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class BMotionEditorPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "de.bmotionstudio.gef.editor";
    public static final String FILEEXT_STUDIO = "bmso";
    private static BMotionEditorPlugin plugin;
    private static HashMap<String, IConfigurationElement> controlExtensions;
    private static HashMap<String, IConfigurationElement> observerExtensions;
    private static HashMap<String, IConfigurationElement> schedulerExtensions;
    private static HashMap<String, IConfigurationElement> controlServices;
    IExtensionRegistry registry = Platform.getExtensionRegistry();
    static BMotionStudioEditorPage activeBMotionStudioEditor;

    static {
        controlExtensions = new HashMap();
        observerExtensions = new HashMap();
        schedulerExtensions = new HashMap();
        controlServices = new HashMap();
        activeBMotionStudioEditor = null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.initExtensionClasses();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static BMotionEditorPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return BMotionEditorPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static IWorkbenchPage getActivePage() {
        return BMotionEditorPlugin.getDefault().internalGetActivePage();
    }

    public static BMotionStudioEditor getActiveEditor() {
        if (BMotionEditorPlugin.getActivePage() != null && BMotionEditorPlugin.getActivePage().getActiveEditor() instanceof BMotionStudioEditor) {
            return (BMotionStudioEditor)BMotionEditorPlugin.getActivePage().getActiveEditor();
        }
        return null;
    }

    private IWorkbenchPage internalGetActivePage() {
        return this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    private void initExtensionClass(String extensionPointID, ArrayList<String> elementIDs, String getAttribute, HashMap<String, IConfigurationElement> hashMap) {
        IExtensionPoint extensionPoint = this.registry.getExtensionPoint(extensionPointID);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if (elementIDs.contains(configurationElement.getName())) {
                    String atr = configurationElement.getAttribute(getAttribute);
                    hashMap.put(atr, configurationElement);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void initExtensionClasses() {
        ArrayList<String> elementIDs = new ArrayList<String>();
        elementIDs.add("control");
        this.initExtensionClass("de.bmotionstudio.gef.editor.control", elementIDs, "id", controlExtensions);
        elementIDs.clear();
        elementIDs.add("control");
        this.initExtensionClass("de.bmotionstudio.gef.editor.control", elementIDs, "id", controlServices);
        elementIDs.clear();
        elementIDs.add("observer");
        this.initExtensionClass("de.bmotionstudio.gef.editor.observer", elementIDs, "class", observerExtensions);
        elementIDs.clear();
        elementIDs.add("schedulerEvent");
        this.initExtensionClass("de.bmotionstudio.gef.editor.schedulerEvent", elementIDs, "class", schedulerExtensions);
    }

    public static IConfigurationElement getControlExtension(String ident) {
        return controlExtensions.get(ident);
    }

    public static IConfigurationElement getObserverExtension(String ident) {
        return observerExtensions.get(ident);
    }

    public static IConfigurationElement getSchedulerExtension(String ident) {
        return schedulerExtensions.get(ident);
    }

    public static HashMap<String, IConfigurationElement> getSchedulerExtensions() {
        return schedulerExtensions;
    }

    public static HashMap<String, IConfigurationElement> getControlServices() {
        return controlServices;
    }

    public static void allowTypes(XStream xstream) {
        xstream.allowTypesByWildcard(new String[]{"de.bmotionstudio.gef.editor.**", "org.eclipse.draw2d.geometry.Point", "org.eclipse.swt.graphics.RGB"});
    }

    public static void setAliases(XStream xstream) {
        xstream.registerConverter((Converter)new BControlListConverter());
        xstream.alias("control", BControl.class);
        xstream.alias("visualization", Visualization.class);
        xstream.alias("guide", BMotionGuide.class);
        xstream.alias("connection", BConnection.class);
        xstream.alias("children", BControlList.class);
        BMotionEditorPlugin.allowTypes(xstream);
    }
}

