/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.scheduler.wizard;

import de.bmotionstudio.gef.editor.eventb.EventBHelper;
import de.bmotionstudio.gef.editor.eventb.MachineContentObject;
import de.bmotionstudio.gef.editor.eventb.MachineOperation;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.scheduler.ExecuteOperationByPredicate;
import de.bmotionstudio.gef.editor.scheduler.PredicateOperation;
import de.bmotionstudio.gef.editor.scheduler.SchedulerEvent;
import de.bmotionstudio.gef.editor.scheduler.SchedulerWizard;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class WizardExecuteOperationByPredicate
extends SchedulerWizard {
    public WizardExecuteOperationByPredicate(BControl bcontrol, SchedulerEvent scheduler) {
        super(bcontrol, scheduler);
        this.addPage((IWizardPage)new SchedulerExecuteOperationByPredicatePage("SchedulerExecuteOperationByPredicatePage"));
    }

    @Override
    protected Boolean prepareToFinish() {
        SchedulerExecuteOperationByPredicatePage page = (SchedulerExecuteOperationByPredicatePage)this.getPage("SchedulerExecuteOperationByPredicatePage");
        Object errorStr = "";
        if (((ExecuteOperationByPredicate)this.getScheduler()).getPredicateOperation().isRandom() && Integer.valueOf(page.getTxtMaxRandomOperations().getText()) <= 0) {
            errorStr = (String)errorStr + "Max Random Operations must be greater than 0.\n";
        }
        if (page.getCbOperation().getCombo().getSelectionIndex() == -1) {
            errorStr = (String)errorStr + "Please select an operation.\n";
        }
        if (((String)errorStr).length() > 0) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"An Error occured", (String)errorStr);
            return false;
        }
        return true;
    }

    @Override
    public Point getSize() {
        return new Point(600, 600);
    }

    private class SchedulerExecuteOperationByPredicatePage
    extends WizardPage {
        private ComboViewer cbOperation;
        private Text txtPredicate;
        private Text txtMaxRandomOperations;
        private Label lbMaxRandomOperations;
        private Composite container;
        private Label renderedOpLabel;
        private Button checkboxRandomMode;
        private ScrolledComposite c1;

        public ComboViewer getCbOperation() {
            return this.cbOperation;
        }

        public Text getTxtMaxRandomOperations() {
            return this.txtMaxRandomOperations;
        }

        protected SchedulerExecuteOperationByPredicatePage(String pageName) {
            super(pageName);
        }

        public void createControl(Composite parent) {
            DataBindingContext dbc = new DataBindingContext();
            this.container = new Composite(parent, 0);
            GridLayout gl = new GridLayout(2, false);
            this.container.setLayout((Layout)gl);
            Label lb = new Label(this.container, 0);
            lb.setText("Select an operation: ");
            GridData gd = new GridData(768);
            gd.heightHint = 50;
            this.cbOperation = new ComboViewer(this.container, 0);
            this.cbOperation.getCombo().setLayoutData((Object)new GridData(300, 50));
            lb = new Label(this.container, 0);
            lb.setText("Predicate: ");
            lb.setLayoutData((Object)new GridData(2));
            this.txtPredicate = new Text(this.container, 2624);
            this.txtPredicate.setLayoutData((Object)gd);
            lb = new Label(this.container, 0);
            lb.setText("Random mode: ");
            lb.setLayoutData((Object)new GridData(2));
            this.checkboxRandomMode = new Button(this.container, 32);
            this.checkboxRandomMode.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SchedulerExecuteOperationByPredicatePage.this.setRandomVisibility(SchedulerExecuteOperationByPredicatePage.this.checkboxRandomMode.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.lbMaxRandomOperations = new Label(this.container, 0);
            this.lbMaxRandomOperations.setText("Max Random Operations: ");
            this.lbMaxRandomOperations.setLayoutData((Object)new GridData(2));
            this.txtMaxRandomOperations = new Text(this.container, 2048);
            this.txtMaxRandomOperations.setLayoutData((Object)new GridData(768));
            this.txtMaxRandomOperations.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String string = e.text;
                    char[] chars = new char[string.length()];
                    string.getChars(0, chars.length, chars, 0);
                    int i = 0;
                    while (i < chars.length) {
                        if ('0' > chars[i] || chars[i] > '9') {
                            e.doit = false;
                            return;
                        }
                        ++i;
                    }
                }
            });
            this.setRandomVisibility(((ExecuteOperationByPredicate)WizardExecuteOperationByPredicate.this.getScheduler()).getPredicateOperation().isRandom());
            this.initBindings(dbc);
            IStructuredSelection structuredSelection = (IStructuredSelection)this.cbOperation.getSelection();
            if (!structuredSelection.isEmpty()) {
                this.createRenderedOperationContainer((MachineOperation)structuredSelection.getFirstElement());
            }
            this.setControl((Control)this.container);
        }

        private void setRandomVisibility(boolean b) {
            if (this.lbMaxRandomOperations == null || this.txtMaxRandomOperations == null) {
                return;
            }
            this.lbMaxRandomOperations.setVisible(b);
            this.txtMaxRandomOperations.setVisible(b);
        }

        private void initBindings(DataBindingContext dbc) {
            ObservableListContentProvider cbOpContentProvider = new ObservableListContentProvider();
            this.cbOperation.setContentProvider((IContentProvider)cbOpContentProvider);
            IObservableMap[] attributeMaps = new IObservableMap[]{BeanProperties.value(MachineContentObject.class, (String)"label").observeDetail(cbOpContentProvider.getKnownElements())};
            this.cbOperation.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(attributeMaps));
            this.cbOperation.setInput((Object)new WritableList(EventBHelper.getOperations(WizardExecuteOperationByPredicate.this.getBControl().getVisualization()), MachineOperation.class));
            this.cbOperation.getCombo().setFont(new Font((Device)Display.getDefault(), new FontData("Arial", 10, 0)));
            IViewerObservableValue observeSelection = ViewerProperties.singleSelection().observe((Viewer)this.cbOperation);
            dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)this.cbOperation.getCombo()), BeanProperties.value(PredicateOperation.class, (String)"operationName").observe((Object)((ExecuteOperationByPredicate)WizardExecuteOperationByPredicate.this.getScheduler()).getPredicateOperation()), null, null);
            dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.txtPredicate), BeanProperties.value(PredicateOperation.class, (String)"predicate").observe((Object)((ExecuteOperationByPredicate)WizardExecuteOperationByPredicate.this.getScheduler()).getPredicateOperation()));
            observeSelection.addValueChangeListener(new IValueChangeListener(){

                public void handleValueChange(ValueChangeEvent event) {
                    Object sel = event.getObservableValue().getValue();
                    SchedulerExecuteOperationByPredicatePage.this.createRenderedOperationContainer((MachineOperation)sel);
                }
            });
            dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)this.checkboxRandomMode), BeanProperties.value(PredicateOperation.class, (String)"random").observe((Object)((ExecuteOperationByPredicate)WizardExecuteOperationByPredicate.this.getScheduler()).getPredicateOperation()));
            dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.txtMaxRandomOperations), BeanProperties.value(PredicateOperation.class, (String)"maxrandom").observe((Object)((ExecuteOperationByPredicate)WizardExecuteOperationByPredicate.this.getScheduler()).getPredicateOperation()));
        }

        private void createRenderedOperationContainer(MachineOperation op) {
            if (this.c1 != null) {
                this.c1.dispose();
            }
            GridLayout gl = new GridLayout(1, true);
            gl.marginLeft = 5;
            gl.marginTop = 5;
            GridData gd = new GridData(1808);
            gd.horizontalSpan = 2;
            this.c1 = new ScrolledComposite(this.container, 2816);
            this.c1.setBackground(ColorConstants.red);
            this.c1.setLayoutData((Object)gd);
            Composite cp = new Composite((Composite)this.c1, 0);
            cp.setLayout((Layout)gl);
            this.renderedOpLabel = new Label(cp, 0);
            this.renderedOpLabel.setLayoutData((Object)gd);
            this.renderedOpLabel.setText(op.getRenderedOperation());
            this.renderedOpLabel.setFont(JFaceResources.getFontRegistry().get("org.rodinp.keyboard.textFont"));
            this.c1.setContent((Control)cp);
            this.c1.setExpandHorizontal(true);
            this.c1.setExpandVertical(true);
            this.c1.setMinSize(cp.computeSize(-1, -1));
            this.container.layout();
        }
    }
}

