/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.scheduler;

import de.bmotionstudio.gef.editor.BindingObject;
import de.bmotionstudio.gef.editor.scheduler.AnimationScriptStep;
import java.util.Vector;

public class AnimationScriptObject
extends BindingObject
implements Cloneable {
    private Vector<AnimationScriptStep> steps;
    private String predicate;

    public AnimationScriptObject() {
    }

    public AnimationScriptObject(String predicate) {
        this(predicate, new Vector<AnimationScriptStep>());
    }

    public AnimationScriptObject(String predicate, Vector<AnimationScriptStep> steps) {
        this.predicate = predicate;
        this.steps = steps;
    }

    public void setSteps(Vector<AnimationScriptStep> steps) {
        Vector<AnimationScriptStep> oldValue = this.steps;
        this.steps = steps;
        this.firePropertyChange("steps", oldValue, this.steps);
    }

    public Vector<AnimationScriptStep> getSteps() {
        if (this.steps == null) {
            this.steps = new Vector();
        }
        return this.steps;
    }

    public void setPredicate(String predicate) {
        String oldValue = this.predicate;
        this.predicate = predicate;
        this.firePropertyChange("predicate", oldValue, this.predicate);
    }

    public String getPredicate() {
        return this.predicate;
    }

    @Override
    public AnimationScriptObject clone() throws CloneNotSupportedException {
        Vector<AnimationScriptStep> tmpVector = new Vector<AnimationScriptStep>();
        for (AnimationScriptStep p : this.getSteps()) {
            tmpVector.add(p.clone());
        }
        AnimationScriptObject tmpObj = (AnimationScriptObject)super.clone();
        tmpObj.setSteps(tmpVector);
        return tmpObj;
    }
}

