/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.part;

import de.bmotionstudio.gef.editor.BMotionStudioImage;
import de.bmotionstudio.gef.editor.ButtonGroupHelper;
import de.bmotionstudio.gef.editor.edit.TextCellEditorLocator;
import de.bmotionstudio.gef.editor.edit.TextEditManager;
import de.bmotionstudio.gef.editor.editpolicy.BMSConnectionEditPolicy;
import de.bmotionstudio.gef.editor.editpolicy.BMSDeletePolicy;
import de.bmotionstudio.gef.editor.editpolicy.CustomDirectEditPolicy;
import de.bmotionstudio.gef.editor.editpolicy.RenamePolicy;
import de.bmotionstudio.gef.editor.figure.AbstractBMotionFigure;
import de.bmotionstudio.gef.editor.figure.RadioButtonFigure;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.part.BMSAbstractEditPart;
import java.beans.PropertyChangeEvent;
import java.util.Collection;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.swt.graphics.RGB;

public class BRadioButtonPart
extends BMSAbstractEditPart {
    private ChangeListener changeListener = new ChangeListener(){

        public void handleStateChanged(ChangeEvent event) {
            if (event.getPropertyName().equals("pressed")) {
                BControl control = (BControl)BRadioButtonPart.this.getModel();
                control.getVisualization().getAnimation().checkObserver();
                String btgroupid = control.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeButtonGroup").toString();
                if (!btgroupid.trim().equals("")) {
                    Collection<BControl> btGroup = ButtonGroupHelper.getButtonGroup(btgroupid);
                    for (BControl c : btGroup) {
                        c.setAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeChecked", false);
                    }
                }
                control.setAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeChecked", true);
            }
        }
    };

    @Override
    public void activate() {
        super.activate();
        if (this.isRunning().booleanValue() && this.getFigure() instanceof AbstractBMotionFigure) {
            ((AbstractBMotionFigure)this.getFigure()).addChangeListener(this.changeListener);
        }
    }

    @Override
    public void deactivate() {
        if (this.isRunning().booleanValue() && this.getFigure() instanceof AbstractBMotionFigure) {
            ((AbstractBMotionFigure)this.getFigure()).removeChangeListener(this.changeListener);
        }
        super.deactivate();
    }

    @Override
    protected IFigure createEditFigure() {
        RadioButtonFigure fig = new RadioButtonFigure();
        return fig;
    }

    @Override
    public void refreshEditFigure(IFigure figure, BControl model, PropertyChangeEvent pEvent) {
        String btgroup;
        Object value = pEvent.getNewValue();
        String aID = pEvent.getPropertyName();
        if (aID.equals("de.bmotionstudio.gef.editor.attribute.BAttributeVisible")) {
            ((RadioButtonFigure)figure).setVisible(Boolean.valueOf(value.toString()));
        }
        if (aID.equals("de.bmotionstudio.gef.editor.attribute.BAttributeChecked")) {
            Boolean bol = Boolean.valueOf(value.toString());
            if (bol.booleanValue()) {
                ((RadioButtonFigure)figure).setImage(BMotionStudioImage.getImage("img_radiobutton_checked"));
            } else {
                ((RadioButtonFigure)figure).setImage(BMotionStudioImage.getImage("img_radiobutton_unchecked"));
            }
        }
        if (aID.equals("de.bmotionstudio.gef.editor.attribute.BAttributeText")) {
            int addWidth = ((RadioButtonFigure)figure).setText(value.toString());
            ((BControl)this.getModel()).setAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeWidth", 30 + addWidth);
        }
        if (aID.equals("de.bmotionstudio.gef.editor.attribute.BAttributeTextColor")) {
            RGB rgbText = (RGB)value;
            ((RadioButtonFigure)figure).setTextColor(rgbText);
        }
        if (aID.equals("de.bmotionstudio.gef.editor.attribute.BAttributeButtonGroup") && !(btgroup = value.toString()).trim().equals("")) {
            ButtonGroupHelper.addToButtonGroup(btgroup, (BControl)this.getModel());
        }
        if (aID.equals("de.bmotionstudio.gef.editor.attribute.BAttributeEnabled")) {
            ((RadioButtonFigure)figure).setBtEnabled(Boolean.valueOf(value.toString()));
        }
    }

    @Override
    protected void prepareEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new BMSDeletePolicy());
        this.installEditPolicy("NodeEditPolicy", (EditPolicy)new RenamePolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new CustomDirectEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new BMSConnectionEditPolicy());
    }

    @Override
    protected void prepareRunPolicies() {
    }

    private void performDirectEdit() {
        new TextEditManager(this, new TextCellEditorLocator(this.getFigure())).show();
    }

    @Override
    public void performRequest(Request request) {
        super.performRequest(request);
        if (request.getType() == "direct edit" && !this.isRunning().booleanValue()) {
            this.performDirectEdit();
        }
    }
}

