/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.observer.wizard;

import de.bmotionstudio.gef.editor.eventb.EventBHelper;
import de.bmotionstudio.gef.editor.eventb.MachineContentObject;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.observer.Observer;
import de.bmotionstudio.gef.editor.observer.ObserverWizard;
import de.bmotionstudio.gef.editor.observer.TableObserver;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eventb.core.ast.PowerSetType;

public class WizardTableObserver
extends ObserverWizard {
    public WizardTableObserver(BControl bcontrol, Observer bobserver) {
        super(bcontrol, bobserver);
        this.addPage((IWizardPage)new TableObserverPage("TableObserverPage"));
    }

    @Override
    protected Boolean prepareToFinish() {
        TableObserverPage page = (TableObserverPage)this.getPage("TableObserverPage");
        Object errorStr = "";
        if (page.getTxtExpression().getText().length() == 0) {
            errorStr = (String)errorStr + "Please enter an expression.\n";
        }
        if (page.getErrorMessage() != null) {
            errorStr = (String)errorStr + "Please check the syntax/parser error.\n";
        }
        if (((String)errorStr).length() > 0) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"An Error occured", (String)errorStr);
            return false;
        }
        return true;
    }

    @Override
    public Point getSize() {
        return new Point(600, 500);
    }

    private class TableObserverPage
    extends WizardPage {
        private Text txtExpression;
        private Text txtPredicate;
        private Button cbOverrideCells;
        private Button cbKeepHeader;

        public Text getTxtExpression() {
            return this.txtExpression;
        }

        protected TableObserverPage(String pageName) {
            super(pageName);
        }

        public void createControl(Composite parent) {
            DataBindingContext dbc = new DataBindingContext();
            parent.setLayout((Layout)new GridLayout(1, true));
            Group group = new Group(parent, 0);
            group.setText("General settings");
            RowLayout rowLayout = new RowLayout();
            rowLayout.marginLeft = 10;
            rowLayout.marginTop = 10;
            rowLayout.marginBottom = 10;
            group.setLayout((Layout)rowLayout);
            group.setLayoutData((Object)new GridData(768));
            this.cbOverrideCells = new Button((Composite)group, 32);
            this.cbOverrideCells.setText("Override cells");
            this.cbKeepHeader = new Button((Composite)group, 32);
            this.cbKeepHeader.setText("Keep header");
            Group container = new Group(parent, 0);
            container.setText("Formal model");
            container.setLayout((Layout)new GridLayout(2, false));
            container.setLayoutData((Object)new GridData(1808));
            Composite conLeft = new Composite((Composite)container, 0);
            conLeft.setLayoutData((Object)new GridData(1808));
            conLeft.setLayout((Layout)new GridLayout(2, false));
            Label lb = new Label(conLeft, 0);
            lb.setText("Predicate:");
            this.txtPredicate = new Text(conLeft, 2048);
            this.txtPredicate.setLayoutData((Object)new GridData(768));
            this.txtPredicate.setFont(new Font((Device)Display.getDefault(), new FontData("Arial", 10, 0)));
            lb = new Label(conLeft, 0);
            lb.setText("Expression:");
            lb.setLayoutData((Object)new GridData(2));
            this.txtExpression = new Text(conLeft, 2114);
            this.txtExpression.setLayoutData((Object)new GridData(1808));
            Composite conRight = new Composite((Composite)container, 0);
            GridData gData = new GridData(1040);
            gData.widthHint = 125;
            conRight.setLayoutData((Object)gData);
            conRight.setLayout((Layout)new GridLayout(1, false));
            lb = new Label(conRight, 64);
            lb.setText("Power sets:");
            lb.setLayoutData((Object)new GridData(2));
            ArrayList<String> relationList = new ArrayList<String>();
            List<MachineContentObject> constants = EventBHelper.getConstants(WizardTableObserver.this.getBControl().getVisualization());
            for (MachineContentObject mobj : constants) {
                if (!(mobj.getType() instanceof PowerSetType)) continue;
                relationList.add(mobj.getLabel());
            }
            List<MachineContentObject> variables = EventBHelper.getVariables(WizardTableObserver.this.getBControl().getVisualization());
            for (MachineContentObject mobj : variables) {
                if (!(mobj.getType() instanceof PowerSetType)) continue;
                relationList.add(mobj.getLabel());
            }
            final org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(conRight, 2564);
            list.setLayoutData((Object)new GridData(1808));
            list.setItems(relationList.toArray(new String[relationList.size()]));
            list.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    String[] selection = list.getSelection();
                    if (selection.length > 0) {
                        TableObserverPage.this.txtExpression.setText(TableObserverPage.this.txtExpression.getText() + " " + selection[0]);
                    }
                }
            });
            this.initBindings(dbc);
            this.setControl((Control)conLeft);
        }

        private void initBindings(DataBindingContext dbc) {
            dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.txtPredicate), BeanProperties.value(TableObserver.class, (String)"predicate").observe((Object)((TableObserver)WizardTableObserver.this.getObserver())));
            dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.txtExpression), BeanProperties.value(TableObserver.class, (String)"expression").observe((Object)((TableObserver)WizardTableObserver.this.getObserver())));
            dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)this.cbOverrideCells), BeanProperties.value(TableObserver.class, (String)"overrideCells").observe((Object)((TableObserver)WizardTableObserver.this.getObserver())));
            dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)this.cbKeepHeader), BeanProperties.value(TableObserver.class, (String)"keepHeader").observe((Object)((TableObserver)WizardTableObserver.this.getObserver())));
        }
    }
}

