/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.observer.wizard;

import de.bmotionstudio.gef.editor.BMotionAbstractWizard;
import de.bmotionstudio.gef.editor.BMotionStudioImage;
import de.bmotionstudio.gef.editor.attribute.AbstractAttribute;
import de.bmotionstudio.gef.editor.edit.AttributeExpressionEdittingSupport;
import de.bmotionstudio.gef.editor.edit.IsExpressionModeEditingSupport;
import de.bmotionstudio.gef.editor.edit.OperationValueEditingSupport;
import de.bmotionstudio.gef.editor.edit.PredicateEditingSupport;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.observer.ListenOperationByPredicate;
import de.bmotionstudio.gef.editor.observer.Observer;
import de.bmotionstudio.gef.editor.observer.ObserverEvalObject;
import de.bmotionstudio.gef.editor.observer.ObserverWizard;
import de.bmotionstudio.gef.editor.observer.wizard.AbstractObserverWizardPage;
import de.bmotionstudio.gef.editor.property.CheckboxCellEditorHelper;
import de.bmotionstudio.gef.editor.scheduler.PredicateOperation;
import de.bmotionstudio.gef.editor.util.BMotionWizardUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.list.ComputedList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class WizardObserverListenOperationByPredicate
extends ObserverWizard {
    public WizardObserverListenOperationByPredicate(BControl bcontrol, Observer bobserver) {
        super(bcontrol, bobserver);
        this.addPage((IWizardPage)new ObserverListenOperationByPredicatePage("ObserverListenOperationByPredicatePage"));
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    @Override
    protected Boolean prepareToFinish() {
        if (((ListenOperationByPredicate)this.getObserver()).getList().size() == 0) {
            this.setObserverDelete(true);
        } else {
            for (PredicateOperation obj : ((ListenOperationByPredicate)this.getObserver()).getList()) {
                if (obj.getOperationName().isEmpty()) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Please check your entries", (String)"Please check your entries. The operation field must not be empty.");
                    return false;
                }
                if (obj.getAttribute() != null) continue;
                MessageDialog.openError((Shell)this.getShell(), (String)"Please check your entries", (String)"Please check your entries. The attribute field must not be empty.");
                return false;
            }
        }
        return true;
    }

    @Override
    public Point getSize() {
        return new Point(800, 500);
    }

    private class ObserverLabelProvider
    extends ObservableMapLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider,
    ITableFontProvider {
        public ObserverLabelProvider(IObservableMap[] attributeMaps) {
            super(attributeMaps);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 4) {
                return CheckboxCellEditorHelper.getCellEditorImage(((PredicateOperation)element).isExpressionMode());
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            PredicateOperation obj = (PredicateOperation)element;
            if (columnIndex == 2) {
                String atrID = obj.getAttribute();
                String atrName = "";
                if (atrID != null && atrID.length() > 0) {
                    atrName = WizardObserverListenOperationByPredicate.this.getBControl().getAttributes().get(atrID).getName();
                }
                return atrName;
            }
            if (columnIndex == 3) {
                if (obj.getValue() != null) {
                    return obj.getValue().toString();
                }
                return "";
            }
            if (columnIndex == 4) {
                return "";
            }
            return super.getColumnText(element, columnIndex);
        }

        public Color getBackground(Object element, int column) {
            return null;
        }

        public Color getForeground(Object element, int column) {
            return null;
        }

        public Font getFont(Object element, int column) {
            return null;
        }
    }

    private class ObserverListenOperationByPredicatePage
    extends AbstractObserverWizardPage {
        private TableViewer tableViewer;

        protected ObserverListenOperationByPredicatePage(String pageName) {
            super(pageName, WizardObserverListenOperationByPredicate.this.getObserver());
        }

        @Override
        public void createControl(Composite parent) {
            super.createControl(parent);
            DataBindingContext dbc = new DataBindingContext();
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(1, true));
            this.setControl((Control)container);
            this.tableViewer = BMotionWizardUtil.createBMotionWizardTableViewer(container, PredicateOperation.class, ((BMotionAbstractWizard)this.getWizard()).getName());
            TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
            column.getColumn().setText("Operation");
            column.getColumn().setWidth(150);
            column.setEditingSupport((EditingSupport)new OperationValueEditingSupport(this.tableViewer, WizardObserverListenOperationByPredicate.this.getBControl()));
            column = new TableViewerColumn(this.tableViewer, 0);
            column.getColumn().setText("Predicate");
            column.getColumn().setWidth(150);
            column.setEditingSupport((EditingSupport)new PredicateEditingSupport(this.tableViewer, dbc, "predicate", WizardObserverListenOperationByPredicate.this.getBControl().getVisualization(), this.getShell()));
            column = new TableViewerColumn(this.tableViewer, 0);
            column.getColumn().setText("Attribute");
            column.getColumn().setWidth(150);
            column.setEditingSupport((EditingSupport)new AttributeObserverValueEditing(this.tableViewer));
            column = new TableViewerColumn(this.tableViewer, 0);
            column.getColumn().setText("Value");
            column.getColumn().setWidth(175);
            column.setEditingSupport((EditingSupport)new AttributeExpressionEdittingSupport((ColumnViewer)this.tableViewer, WizardObserverListenOperationByPredicate.this.getBControl()));
            column = new TableViewerColumn(this.tableViewer, 0);
            column.getColumn().setText("Expression?");
            column.getColumn().setWidth(100);
            column.setEditingSupport((EditingSupport)new IsExpressionModeEditingSupport((ColumnViewer)this.tableViewer, WizardObserverListenOperationByPredicate.this.getBControl()));
            ObservableListContentProvider contentProvider = new ObservableListContentProvider();
            this.tableViewer.setContentProvider((IContentProvider)contentProvider);
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new ObserverLabelProvider(new IObservableMap[]{BeanProperties.value(PredicateOperation.class, (String)"operationName").observeDetail(contentProvider.getKnownElements()), BeanProperties.value(PredicateOperation.class, (String)"predicate").observeDetail(contentProvider.getKnownElements()), BeanProperties.value(ObserverEvalObject.class, (String)"attribute").observeDetail(contentProvider.getKnownElements()), BeanProperties.value(ObserverEvalObject.class, (String)"value").observeDetail(contentProvider.getKnownElements()), BeanProperties.value(ObserverEvalObject.class, (String)"isExpressionMode").observeDetail(contentProvider.getKnownElements())}));
            final WritableList input = new WritableList(((ListenOperationByPredicate)WizardObserverListenOperationByPredicate.this.getObserver()).getList(), PredicateOperation.class);
            this.tableViewer.setInput((Object)input);
            Composite comp = new Composite(container, 0);
            comp.setLayout((Layout)new RowLayout());
            comp.setLayoutData((Object)new GridData(128));
            Button btRemove = new Button(comp, 8);
            btRemove.setText("Remove");
            btRemove.setImage(BMotionStudioImage.getImage("icon_delete_edit"));
            btRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ObserverListenOperationByPredicatePage.this.tableViewer.getSelection().isEmpty()) {
                        return;
                    }
                    PredicateOperation obj = (PredicateOperation)((IStructuredSelection)ObserverListenOperationByPredicatePage.this.tableViewer.getSelection()).getFirstElement();
                    input.remove((Object)obj);
                }
            });
            Button btAdd = new Button(comp, 8);
            btAdd.setText("Add");
            btAdd.setImage(BMotionStudioImage.getImage("icon_new_wiz"));
            btAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PredicateOperation obj = new PredicateOperation();
                    input.add((Object)obj);
                    ObserverListenOperationByPredicatePage.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)obj));
                }
            });
        }

        private class AttributeObserverValueEditing
        extends EditingSupport {
            private ComboBoxViewerCellEditor cellEditor;

            public AttributeObserverValueEditing(TableViewer cv) {
                super((ColumnViewer)cv);
                this.cellEditor = null;
            }

            protected boolean canEdit(Object element) {
                return BMotionWizardUtil.isEditElement(this.getViewer());
            }

            protected Object getValue(Object element) {
                return ((PredicateOperation)element).getAttribute();
            }

            protected void setValue(Object element, Object value) {
                if (value != null) {
                    PredicateOperation obj = (PredicateOperation)element;
                    obj.setAttribute(value.toString());
                    obj.setIsExpressionMode(false);
                }
            }

            protected CellEditor getCellEditor(Object element) {
                if (this.cellEditor == null) {
                    this.cellEditor = new ComboBoxViewerCellEditor((Composite)ObserverListenOperationByPredicatePage.this.tableViewer.getControl(), 8);
                    this.cellEditor.setContentProvider((IStructuredContentProvider)new ObservableListContentProvider());
                    this.cellEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                        public String getText(Object element) {
                            return WizardObserverListenOperationByPredicate.this.getBControl().getAttributes().get(element.toString()).getName();
                        }
                    });
                    this.cellEditor.setInput((Object)new ComputedList(){

                        protected List<String> calculate() {
                            ArrayList<String> atrList = new ArrayList<String>();
                            for (AbstractAttribute atr : WizardObserverListenOperationByPredicate.this.getBControl().getAttributes().values()) {
                                atrList.add(atr.getID());
                            }
                            return atrList;
                        }
                    });
                    ((CCombo)this.cellEditor.getControl()).addFocusListener(new FocusListener(){
                        String oldValue;

                        public void focusGained(FocusEvent e) {
                            this.oldValue = ((CCombo)AttributeObserverValueEditing.this.cellEditor.getControl()).getText();
                        }

                        public void focusLost(FocusEvent e) {
                            if (!this.oldValue.equals(((CCombo)AttributeObserverValueEditing.this.cellEditor.getControl()).getText())) {
                                IStructuredSelection selection = (IStructuredSelection)AttributeObserverValueEditing.this.getViewer().getSelection();
                                PredicateOperation p = (PredicateOperation)selection.getFirstElement();
                                AbstractAttribute atr = WizardObserverListenOperationByPredicate.this.getBControl().getAttributes().get(p.getAttribute());
                                p.setValue(atr.getValue());
                                ((AttributeObserverValueEditing)AttributeObserverValueEditing.this).ObserverListenOperationByPredicatePage.this.tableViewer.refresh();
                            }
                        }
                    });
                }
                return this.cellEditor;
            }
        }
    }
}

