/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.observer;

import de.bmotionstudio.gef.editor.Animation;
import de.bmotionstudio.gef.editor.attribute.AbstractAttribute;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.observer.Observer;
import de.bmotionstudio.gef.editor.observer.ObserverWizard;
import de.bmotionstudio.gef.editor.observer.wizard.WizardTableObserver;
import de.bmotionstudio.gef.editor.util.BMSUtil;
import de.prob.unicode.UnicodeTranslator;
import java.util.LinkedList;
import java.util.List;

public class TableObserver
extends Observer {
    private String expression;
    private String predicate;
    private boolean overrideCells;
    private boolean keepHeader;

    public static List<String> split(String input, char tempReplacement) {
        while (input.matches(".*\\{[^\\}]+,[^\\}]+\\}.*")) {
            input = input.replaceAll("(\\{[^\\}]+),([^\\}]+\\})", "$1" + tempReplacement + "$2");
        }
        LinkedList<String> output = new LinkedList<String>();
        if (input.length() > 0) {
            String[] split;
            String[] stringArray = split = input.split(",");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                output.add(s.replaceAll("" + tempReplacement, ",").trim());
                ++n2;
            }
        }
        return output;
    }

    public static List<String> split2(String input, char tempReplacement) {
        while (input.matches(".*\\([^\\)]+\\|->[^\\)]+\\).*")) {
            input = input.replaceAll("(\\([^\\)]+)\\|->([^\\)]+\\))", "$1" + tempReplacement + "$2");
        }
        LinkedList<String> output = new LinkedList<String>();
        if (input.length() > 0) {
            String[] split;
            String[] stringArray = split = input.split("\\|->");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                output.add(s.replaceAll("" + tempReplacement, "\\|->").trim());
                ++n2;
            }
        }
        return output;
    }

    @Override
    public void check(Animation animation, BControl control) {
        String bolValue = "true";
        if (this.predicate != null && this.predicate.length() > 0) {
            bolValue = BMSUtil.parsePredicate(this.predicate, control, animation);
        }
        if (Boolean.valueOf(bolValue).booleanValue()) {
            String fEval = BMSUtil.parseExpression(this.expression, control, animation);
            fEval = UnicodeTranslator.toAscii((String)fEval);
            fEval = fEval.replaceAll("^\\{", "");
            String input = fEval = fEval.replaceAll("\\}$", "");
            List<String> rows = TableObserver.split(input, '#');
            Integer numberOfOldRows = 0;
            Integer numberOfOldColumns = 0;
            if (!this.overrideCells) {
                AbstractAttribute attributeRows = control.getAttribute("de.bmotionstudio.gef.editor.attribute.BAttributeRows");
                numberOfOldRows = Integer.valueOf(attributeRows.getInitValue().toString());
                AbstractAttribute attributeColumns = control.getAttribute("de.bmotionstudio.gef.editor.attribute.BAttributeColumns");
                numberOfOldColumns = Integer.valueOf(attributeColumns.getInitValue().toString());
            } else if (this.keepHeader) {
                numberOfOldRows = 1;
            }
            int numberOfNewRows = rows.size();
            control.setAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeRows", numberOfNewRows + numberOfOldRows, true, false);
            boolean setColumns = false;
            int i = numberOfOldRows;
            while (i < numberOfNewRows + numberOfOldRows) {
                String content = rows.get(i - numberOfOldRows);
                if (content != null && content.length() > 0) {
                    content = UnicodeTranslator.toAscii((String)content);
                }
                content = content.replaceAll("^\\(", "");
                content = content.replaceAll("\\)$", "");
                List<String> columns = TableObserver.split2(content, '#');
                int numberOfNewColumns = columns.size();
                if (!setColumns) {
                    int ncolumns = numberOfNewColumns;
                    if (numberOfOldColumns > numberOfNewColumns) {
                        ncolumns = numberOfOldColumns;
                    }
                    control.setAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeColumns", ncolumns, true, false);
                    setColumns = true;
                }
                int z = 0;
                while (z < numberOfNewColumns) {
                    String val = columns.get(z);
                    BControl column = control.getChildrenArray().get(z);
                    BControl cell = column.getChildrenArray().get(i);
                    if (val != null && val.length() > 0) {
                        val = UnicodeTranslator.toUnicode((String)val);
                    }
                    cell.setAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeText", val);
                    ++z;
                }
                ++i;
            }
        }
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getPredicate() {
        return this.predicate;
    }

    public void setPredicate(String predicate) {
        this.predicate = predicate;
    }

    @Override
    public ObserverWizard getWizard(BControl control) {
        return new WizardTableObserver(control, this);
    }

    public boolean isOverrideCells() {
        return this.overrideCells;
    }

    public void setOverrideCells(boolean overrideCells) {
        this.overrideCells = overrideCells;
    }

    public boolean isKeepHeader() {
        return this.keepHeader;
    }

    public void setKeepHeader(boolean keepHeader) {
        this.keepHeader = keepHeader;
    }
}

