/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.observer;

import de.bmotionstudio.gef.editor.Animation;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.observer.Observer;
import de.bmotionstudio.gef.editor.observer.ObserverWizard;
import de.bmotionstudio.gef.editor.observer.ToggleObjectImage;
import de.bmotionstudio.gef.editor.observer.wizard.WizardObserverSwitchImage;
import de.bmotionstudio.gef.editor.util.BMSUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;

public class SwitchImage
extends Observer {
    private List<ToggleObjectImage> toggleObjects = new ArrayList<ToggleObjectImage>();

    @Override
    public void check(Animation animation, BControl control) {
        boolean set = false;
        for (ToggleObjectImage obj : this.toggleObjects) {
            obj.setHasError(false);
            String bolValue = "true";
            if (obj.getEval().length() > 0) {
                bolValue = BMSUtil.parsePredicate(obj.getEval(), control, animation);
            }
            if (obj.hasError().booleanValue() || !Boolean.valueOf(bolValue).booleanValue()) continue;
            String fImage = obj.getImage();
            if (obj.isExpressionMode().booleanValue()) {
                fImage = BMSUtil.parseExpression(obj.getImage(), control, animation);
            }
            IFile pFile = control.getVisualization().getProjectFile();
            String myPath = (String.valueOf(pFile.getProject().getLocation()) + "/images/" + fImage).replace("file:", "");
            new File(myPath).exists();
            if (!obj.hasError().booleanValue() && !control.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeImage").equals(fImage)) {
                control.setAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeImage", fImage, true, false);
            }
            set = true;
        }
        if (!set) {
            control.restoreDefaultValue("de.bmotionstudio.gef.editor.attribute.BAttributeImage");
        }
    }

    @Override
    public ObserverWizard getWizard(BControl bcontrol) {
        return new WizardObserverSwitchImage(bcontrol, this);
    }

    public List<ToggleObjectImage> getToggleObjects() {
        return this.toggleObjects;
    }

    public void setToggleObjects(List<ToggleObjectImage> list) {
        this.toggleObjects = list;
    }

    @Override
    public Observer clone() throws CloneNotSupportedException {
        SwitchImage clonedObserver = (SwitchImage)super.clone();
        ArrayList<ToggleObjectImage> list = new ArrayList<ToggleObjectImage>();
        for (ToggleObjectImage obj : this.getToggleObjects()) {
            list.add(obj.clone());
        }
        clonedObserver.setToggleObjects(list);
        return clonedObserver;
    }
}

