/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.model;

import de.bmotionstudio.gef.editor.command.CreateGuideCommand;
import de.bmotionstudio.gef.editor.command.DeleteGuideCommand;
import de.bmotionstudio.gef.editor.command.MoveGuideCommand;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.model.BMotionGuide;
import de.bmotionstudio.gef.editor.model.BMotionRuler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.rulers.RulerChangeListener;
import org.eclipse.gef.rulers.RulerProvider;

public class BMotionRulerProvider
extends RulerProvider {
    private BMotionRuler ruler;
    private PropertyChangeListener rulerListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("children changed")) {
                BMotionGuide guide = (BMotionGuide)evt.getNewValue();
                if (BMotionRulerProvider.this.getGuides().contains(guide)) {
                    guide.addPropertyChangeListener(BMotionRulerProvider.this.guideListener);
                } else {
                    guide.removePropertyChangeListener(BMotionRulerProvider.this.guideListener);
                }
                int i = 0;
                while (i < BMotionRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)BMotionRulerProvider.this.listeners.get(i)).notifyGuideReparented((Object)guide);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < BMotionRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)BMotionRulerProvider.this.listeners.get(i)).notifyUnitsChanged(BMotionRulerProvider.this.ruler.getUnit());
                    ++i;
                }
            }
        }
    };
    private PropertyChangeListener guideListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("subparts changed")) {
                int i = 0;
                while (i < BMotionRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)BMotionRulerProvider.this.listeners.get(i)).notifyPartAttachmentChanged(evt.getNewValue(), evt.getSource());
                    ++i;
                }
            } else {
                int i = 0;
                while (i < BMotionRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)BMotionRulerProvider.this.listeners.get(i)).notifyGuideMoved(evt.getSource());
                    ++i;
                }
            }
        }
    };

    public BMotionRulerProvider(BMotionRuler ruler) {
        this.ruler = ruler;
        this.ruler.addPropertyChangeListener(this.rulerListener);
        List<BMotionGuide> guides = this.getGuides();
        int i = 0;
        while (i < guides.size()) {
            guides.get(i).addPropertyChangeListener(this.guideListener);
            ++i;
        }
    }

    public List<BControl> getAttachedModelObjects(Object guide) {
        return new ArrayList<BControl>(((BMotionGuide)guide).getParts());
    }

    public Command getCreateGuideCommand(int position) {
        return new CreateGuideCommand(this.ruler, position);
    }

    public Command getDeleteGuideCommand(Object guide) {
        return new DeleteGuideCommand((BMotionGuide)guide, this.ruler);
    }

    public Command getMoveGuideCommand(Object guide, int pDelta) {
        return new MoveGuideCommand((BMotionGuide)guide, pDelta);
    }

    public int[] getGuidePositions() {
        List<BMotionGuide> guides = this.getGuides();
        int[] result = new int[guides.size()];
        int i = 0;
        while (i < guides.size()) {
            result[i] = guides.get(i).getPosition();
            ++i;
        }
        return result;
    }

    public Object getRuler() {
        return this.ruler;
    }

    public int getUnit() {
        return this.ruler.getUnit();
    }

    public void setUnit(int newUnit) {
        this.ruler.setUnit(newUnit);
    }

    public int getGuidePosition(Object guide) {
        return ((BMotionGuide)guide).getPosition();
    }

    public List<BMotionGuide> getGuides() {
        return this.ruler.getGuides();
    }
}

