/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.model;

import de.bmotionstudio.gef.editor.model.BControl;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;

public class BMotionGuide
implements Serializable {
    public static final transient String PROPERTY_CHILDREN = "subparts changed";
    public static final transient String PROPERTY_POSITION = "position changed";
    static final transient long serialVersionUID = 1L;
    protected transient PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private HashMap<BControl, Integer> map;
    private int position;
    private boolean horizontal;

    public BMotionGuide() {
    }

    public BMotionGuide(boolean isHorizontal) {
        this.setHorizontal(isHorizontal);
    }

    protected Object readResolve() {
        this.listeners = new PropertyChangeSupport(this);
        return this;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void attachPart(BControl control, int alignment) {
        BMotionGuide parent;
        if (this.getMap().containsKey(control) && this.getAlignment(control) == alignment) {
            return;
        }
        this.getMap().put(control, alignment);
        BMotionGuide bMotionGuide = parent = this.isHorizontal() ? control.getHorizontalGuide() : control.getVerticalGuide();
        if (parent != null && parent != this) {
            parent.detachPart(control);
        }
        if (this.isHorizontal()) {
            control.setHorizontalGuide(this);
        } else {
            control.setVerticalGuide(this);
        }
        this.listeners.firePropertyChange(PROPERTY_CHILDREN, null, control);
    }

    public void detachPart(BControl control) {
        if (this.getMap().containsKey(control)) {
            this.getMap().remove(control);
            if (this.isHorizontal()) {
                control.setHorizontalGuide(null);
            } else {
                control.setVerticalGuide(null);
            }
            this.listeners.firePropertyChange(PROPERTY_CHILDREN, null, control);
        }
    }

    public int getAlignment(BControl part) {
        if (this.getMap().get(part) != null) {
            return this.getMap().get(part);
        }
        return -2;
    }

    public HashMap<BControl, Integer> getMap() {
        if (this.map == null) {
            this.map = new HashMap();
        }
        return this.map;
    }

    public Set<BControl> getParts() {
        return this.getMap().keySet();
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public void setHorizontal(boolean isHorizontal) {
        this.horizontal = isHorizontal;
    }

    public void setPosition(int offset) {
        if (this.position != offset) {
            int oldValue = this.position;
            this.position = offset;
            this.listeners.firePropertyChange(PROPERTY_POSITION, (Object)oldValue, (Object)this.position);
        }
    }
}

