/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.model;

import de.bmotionstudio.gef.editor.attribute.BAttributeConnection;
import de.bmotionstudio.gef.editor.attribute.BAttributeConnectionSourceDecoration;
import de.bmotionstudio.gef.editor.attribute.BAttributeConnectionTargetDecoration;
import de.bmotionstudio.gef.editor.attribute.BAttributeForegroundColor;
import de.bmotionstudio.gef.editor.attribute.BAttributeLabel;
import de.bmotionstudio.gef.editor.attribute.BAttributeLineStyle;
import de.bmotionstudio.gef.editor.attribute.BAttributeLineWidth;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.model.Visualization;
import org.eclipse.swt.graphics.RGB;

public class BConnection
extends BControl {
    public static String TYPE = "de.bmotionstudio.gef.editor.connection";
    protected boolean isConnected;
    protected BControl source;
    protected BControl target;

    public BConnection(Visualization visualization) {
        super(visualization);
    }

    public void disconnect() {
        if (this.isConnected) {
            this.source.removeConnection(this);
            this.target.removeConnection(this);
            this.isConnected = false;
        }
    }

    public BControl getSource() {
        return this.source;
    }

    public BControl getTarget() {
        return this.target;
    }

    public void setTarget(BControl c) {
        this.target = c;
    }

    public void setSource(BControl c) {
        this.source = c;
    }

    public void reconnect() {
        if (!this.isConnected) {
            this.source.addConnection(this);
            this.target.addConnection(this);
            this.isConnected = true;
        }
    }

    public void reconnect(BControl newSource, BControl newTarget) {
        if (newSource == null || newTarget == null || newSource == newTarget) {
            throw new IllegalArgumentException();
        }
        this.disconnect();
        this.source = newSource;
        this.target = newTarget;
        this.reconnect();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected void initAttributes() {
        BAttributeConnection aConnection = new BAttributeConnection(null);
        aConnection.setGroup("de.bmotionstudio.gef.editor.attribute.BAttributeRoot");
        this.initAttribute(aConnection);
        BAttributeLineWidth aLineWidth = new BAttributeLineWidth(1);
        aLineWidth.setGroup(aConnection);
        this.initAttribute(aLineWidth);
        BAttributeLineStyle aLineStyle = new BAttributeLineStyle(0);
        aLineStyle.setGroup(aConnection);
        this.initAttribute(aLineStyle);
        BAttributeForegroundColor aForegroundColor = new BAttributeForegroundColor(new RGB(0, 0, 0));
        aForegroundColor.setGroup(aConnection);
        this.initAttribute(aForegroundColor);
        BAttributeConnectionSourceDecoration aSourceDeco = new BAttributeConnectionSourceDecoration(BAttributeConnectionSourceDecoration.DECORATION_NONE);
        aSourceDeco.setGroup(aConnection);
        this.initAttribute(aSourceDeco);
        BAttributeConnectionTargetDecoration aTargetDeco = new BAttributeConnectionTargetDecoration(BAttributeConnectionSourceDecoration.DECORATION_NONE);
        aTargetDeco.setGroup(aConnection);
        this.initAttribute(aTargetDeco);
        BAttributeLabel aLabel = new BAttributeLabel("Label ...");
        aLabel.setGroup(aConnection);
        this.initAttribute(aLabel);
    }
}

