/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.library;

import de.bmotionstudio.gef.editor.BMotionStudioEditor;
import de.bmotionstudio.gef.editor.BMotionStudioImage;
import de.bmotionstudio.gef.editor.library.AttributeTransfer;
import de.bmotionstudio.gef.editor.library.AttributeTransferObject;
import de.bmotionstudio.gef.editor.library.DeleteItemsAction;
import de.bmotionstudio.gef.editor.library.ImportImagesAction;
import de.bmotionstudio.gef.editor.library.LibraryImageObject;
import de.bmotionstudio.gef.editor.library.LibraryObject;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public class LibraryPage
extends Page {
    private Image previewImage;
    private TableViewer tvLibrary;
    private Canvas previewCanvas;
    private Composite libMainContainer;
    private Action importImagesAction;
    private Action deleteItemAction;
    private BMotionStudioEditor editor;

    public LibraryPage(BMotionStudioEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        this.libMainContainer = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.horizontalSpacing = 0;
        this.libMainContainer.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.horizontalIndent = 0;
        this.previewCanvas = new Canvas(this.libMainContainer, 2048);
        this.previewCanvas.setLayout((Layout)gl);
        this.previewCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (LibraryPage.this.previewImage == null) {
                    e.gc.drawString("No preview...", 0, 0);
                } else {
                    e.gc.drawImage(LibraryPage.this.previewImage, 0, 0);
                }
            }
        });
        this.previewCanvas.setLayoutData((Object)gd);
        Composite libContainer = new Composite(this.libMainContainer, 0);
        libContainer.setLayout((Layout)gl);
        libContainer.setLayoutData((Object)gd);
        this.tvLibrary = new TableViewer(libContainer, 66050);
        this.tvLibrary.getTable().setLayoutData((Object)gd);
        this.tvLibrary.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                LibraryObject obj = (LibraryObject)selection.getFirstElement();
                if (LibraryPage.this.previewImage != null) {
                    LibraryPage.this.previewImage.dispose();
                }
                LibraryPage.this.previewImage = obj != null ? obj.getPreview(LibraryPage.this) : null;
                LibraryPage.this.previewCanvas.redraw();
                LibraryPage.this.updateActionEnablement();
            }
        });
        this.tvLibrary.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0 && LibraryPage.this.deleteItemAction.isEnabled()) {
                    LibraryPage.this.deleteItemAction.run();
                }
            }
        });
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.tvLibrary.setContentProvider((IContentProvider)contentProvider);
        this.tvLibrary.getTable().setLinesVisible(true);
        this.tvLibrary.getTable().setHeaderVisible(true);
        TableViewerColumn column1 = new TableViewerColumn(this.tvLibrary, 0);
        column1.getColumn().setText("Name");
        column1.getColumn().setWidth(190);
        column1.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(((LibraryObject)cell.getElement()).getName());
                cell.setImage(((LibraryObject)cell.getElement()).getImage());
            }
        });
        TableViewerColumn column2 = new TableViewerColumn(this.tvLibrary, 0);
        column2.getColumn().setText("Type");
        column2.getColumn().setWidth(60);
        column2.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(((LibraryObject)cell.getElement()).getType());
            }
        });
        this.createDragAndDropSupport();
        this.createActions();
        this.createContextMenu();
        this.createMenu(this.getSite());
        this.refresh();
    }

    private void createDragAndDropSupport() {
        this.tvLibrary.addDragSupport(1, new Transfer[]{AttributeTransfer.getInstance()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                LibraryObject object = (LibraryObject)((StructuredSelection)LibraryPage.this.tvLibrary.getSelection()).getFirstElement();
                event.data = new AttributeTransferObject(object);
            }

            public void dragStart(DragSourceEvent event) {
            }
        });
    }

    public Control getControl() {
        return this.libMainContainer;
    }

    public void setFocus() {
        this.libMainContainer.setFocus();
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager();
        this.tvLibrary.getControl().setMenu(manager.createContextMenu(this.tvLibrary.getControl()));
        manager.add((IAction)this.deleteItemAction);
    }

    public void refresh() {
        this.tvLibrary.setInput((Object)new WritableList(this.getLibraryObjects(), LibraryObject.class));
        this.updateActionEnablement();
    }

    private List<LibraryObject> getLibraryObjects() {
        String basePath;
        File dir;
        File[] fileList;
        ArrayList<LibraryObject> tmpList = new ArrayList<LibraryObject>();
        if (this.editor != null && (fileList = (dir = new File((basePath = this.editor.getVisualization().getProjectFile().getProject().getLocation().toString().replace("file:", "")) + "/images")).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jpg") || name.toLowerCase().endsWith(".gif") || name.toLowerCase().endsWith(".png");
            }
        })) != null) {
            File[] fileArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                Image img = null;
                img = f.getName().toLowerCase().endsWith(".jpg") ? BMotionStudioImage.getImage("icon_jpg") : BMotionStudioImage.getImage("icon_gif");
                tmpList.add(new LibraryImageObject(f.getName(), "image", img));
                ++n2;
            }
        }
        return tmpList;
    }

    private void createMenu(IPageSite pageSite) {
        pageSite.getActionBars().getToolBarManager().add((IAction)this.importImagesAction);
        pageSite.getActionBars().getToolBarManager().add((IAction)this.deleteItemAction);
    }

    private void createActions() {
        this.importImagesAction = new ImportImagesAction(this);
        this.deleteItemAction = new DeleteItemsAction(this);
    }

    private void updateActionEnablement() {
        IStructuredSelection sel = (IStructuredSelection)this.tvLibrary.getSelection();
        this.deleteItemAction.setEnabled(sel.size() > 0);
    }

    public void dispose() {
        if (this.previewImage != null) {
            this.previewImage.dispose();
        }
        super.dispose();
    }

    public BMotionStudioEditor getEditor() {
        return this.editor;
    }

    public void setEditor(BMotionStudioEditor editor) {
        this.editor = editor;
    }

    public TableViewer getTableViewer() {
        return this.tvLibrary;
    }

    public void setTableViewer(TableViewer viewer) {
        this.tvLibrary = viewer;
    }
}

