/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.internal;

import de.prob.core.domainobjects.Operation;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SelectOperationDialog
extends Dialog {
    private List<Operation> ops;
    private Operation selectedOperation;
    private ListViewer listViewer;

    protected SelectOperationDialog(Shell parentShell, List<Operation> ops) {
        super(parentShell);
        this.ops = ops;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout(2, false);
        gl.marginLeft = 15;
        gl.marginTop = 20;
        container.setLayout((Layout)gl);
        Label lb = new Label(container, 0);
        lb.setText("Select an event:");
        lb.setLayoutData((Object)new GridData(2));
        this.listViewer = new ListViewer(container);
        this.listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listViewer.setInput(this.ops);
        this.listViewer.getList().setLayoutData((Object)new GridData(1808));
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Please select an event ...");
    }

    protected Point getInitialSize() {
        return new Point(600, 250);
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.listViewer.getSelection();
        this.selectedOperation = (Operation)selection.getFirstElement();
        if (this.selectedOperation == null) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"An error occurred", (String)"Please select an event ...");
            return;
        }
        this.setReturnCode(0);
        this.close();
    }

    public Operation getSelectedOperation() {
        return this.selectedOperation;
    }
}

