/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.internal;

import com.thoughtworks.xstream.XStream;
import de.bmotionstudio.gef.editor.BMotionEditorPlugin;
import de.bmotionstudio.gef.editor.BMotionStudioImage;
import de.bmotionstudio.gef.editor.ILanguageService;
import de.bmotionstudio.gef.editor.model.Visualization;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class NewBMotionProjectWizardPage
extends WizardPage {
    private static final String DEFAULT_PROJECT_NAME = "NewBMotionVisualization";
    private IProject selectedProject;
    private final MachineList machineList = new MachineList();
    private MachineEntry selectedEntry = null;
    private Text projectRootText;
    private Text projectText;
    private TableViewer tableViewer;
    private Map<String, ILanguageService> languages = new HashMap<String, ILanguageService>();

    protected NewBMotionProjectWizardPage(IStructuredSelection selection) {
        super("wizardPage");
        this.selectedProject = this.getSelectedFromSelection(selection);
        this.setTitle("New BMotion Studio Visualization");
        this.setDescription("Please select a B-Machine and enter a name for the new BMotion Studio Visualization.");
        this.setImageDescriptor(BMotionStudioImage.getImageDescriptor("icons/logo_bmotion_64.png"));
        this.initLanguageExtensions();
    }

    private void initLanguageExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("de.bmotionstudio.gef.editor.language");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                try {
                    ILanguageService lang = (ILanguageService)configurationElement.createExecutableExtension("service");
                    this.languages.put(configurationElement.getAttribute("id"), lang);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n4;
            }
            ++n2;
        }
    }

    private IProject getSelectedFromSelection(IStructuredSelection selection) {
        Object firstElement;
        if (selection.size() == 1 && (firstElement = selection.getFirstElement()) instanceof IProject) {
            return (IProject)firstElement;
        }
        return null;
    }

    public IProject getProject() {
        return this.selectedProject;
    }

    public InputStream getInitialContents(String fileExtension) throws UnsupportedEncodingException {
        Visualization visualization = new Visualization(this.getSelectedEntry().getMachineFile().getName(), this.getSelectedEntry().getMachineLanguage(), (String)Platform.getBundle((String)"de.bmotionstudio.gef.editor").getHeaders().get("Bundle-Version"));
        XStream xstream = new XStream();
        BMotionEditorPlugin.setAliases(xstream);
        String content = xstream.toXML((Object)visualization);
        return new ByteArrayInputStream(content.getBytes("UTF-8"));
    }

    public String getFileName() {
        if (this.projectText.getText().length() > 0) {
            return this.projectText.getText();
        }
        return DEFAULT_PROJECT_NAME;
    }

    public MachineEntry getSelectedEntry() {
        return this.selectedEntry;
    }

    public String getProjectRoot() {
        return this.projectRootText.getText();
    }

    public String getBMotionProjectName() {
        return this.projectText.getText();
    }

    private void initContent() {
        this.machineList.clearList();
        if (this.selectedProject != null) {
            String basePath = this.selectedProject.getLocation().toString().replace("file:", "");
            File dir = new File(basePath);
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                for (Map.Entry<String, ILanguageService> e : this.languages.entrySet()) {
                    String langID = e.getKey();
                    ILanguageService langService = e.getValue();
                    Path path = new Path(f.getAbsolutePath());
                    IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                    if (!langService.isLanguageFile(ifile)) continue;
                    this.machineList.addEntry(new MachineEntry(ifile, langID));
                }
                ++n2;
            }
        }
        this.tableViewer.setInput((Object)this.machineList.getChildren());
    }

    private boolean resourceExistsInProject(String resourceName) {
        IFile f = this.selectedProject.getFile(resourceName + ".bmso");
        return f.exists();
    }

    public void validateInput() {
        StringBuffer errorMessages = new StringBuffer(150);
        if (this.getProjectRoot().length() == 0) {
            errorMessages.append("The Project name must not be empty.\n");
        }
        if (this.getBMotionProjectName().length() == 0) {
            errorMessages.append("The BMotion Studio Visualization filename must not be empty.\n");
        }
        if (this.getSelectedEntry() == null) {
            errorMessages.append("You have to select a Machine.\n");
        }
        if (errorMessages.length() == 0 && this.resourceExistsInProject(this.getBMotionProjectName())) {
            errorMessages.append("The BMotion Studio Visualization filename must be unique in a project.\n");
        }
        if (errorMessages.length() > 0) {
            this.setErrorMessage(errorMessages.toString());
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 20;
        this.setControl((Control)container);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBMotionProjectWizardPage.this.validateInput();
            }
        };
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        Label label = new Label(container, 0);
        label.setText("&Project folder:");
        this.projectRootText = new Text(container, 2052);
        this.projectRootText.setLayoutData((Object)gd);
        if (this.selectedProject != null) {
            this.projectRootText.setText(this.selectedProject.getFullPath().toOSString());
        }
        this.projectRootText.setEditable(false);
        this.projectRootText.addModifyListener(listener);
        Button button = new Button(container, 0);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] result;
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(NewBMotionProjectWizardPage.this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select Project");
                if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
                    IProject newProject;
                    Path newPath = (Path)result[0];
                    NewBMotionProjectWizardPage.this.selectedProject = newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(newPath.toString());
                    NewBMotionProjectWizardPage.this.initContent();
                    NewBMotionProjectWizardPage.this.projectRootText.setText(((Path)result[0]).toOSString());
                    NewBMotionProjectWizardPage.this.validateInput();
                }
            }
        });
        label = new Label(container, 0);
        label.setText("&Project name:");
        this.projectText = new Text(container, 2052);
        this.projectText.setText(DEFAULT_PROJECT_NAME);
        this.projectText.setLayoutData((Object)gd);
        this.projectText.addModifyListener(listener);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 3;
        label = new Label(container, 0);
        label.setText("&Formal model:");
        label.setLayoutData((Object)gd);
        gd = new GridData(1040);
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.tableViewer = new TableViewer(container, 65540);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)gd);
        String[] columnsNames = new String[]{"Model", "Language"};
        int[] columnWidths = new int[]{250, 100};
        int[] columnAlignments = new int[]{16384, 16384};
        int i = 0;
        while (i < columnsNames.length) {
            TableColumn tableColumn = new TableColumn(table, columnAlignments[i]);
            tableColumn.setText(columnsNames[i]);
            tableColumn.setWidth(columnWidths[i]);
            ++i;
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MachineLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.initContent();
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                NewBMotionProjectWizardPage.this.selectedEntry = (MachineEntry)selection.getFirstElement();
                NewBMotionProjectWizardPage.this.validateInput();
            }
        });
        this.validateInput();
    }

    private static class MachineEntry {
        private final String machineName;
        private final String machineLanguage;
        private final IFile file;

        public MachineEntry(IFile file, String machineLanguage) {
            this.file = file;
            this.machineName = file.getName();
            this.machineLanguage = machineLanguage;
        }

        public String getMachineName() {
            return this.machineName;
        }

        public String getMachineLanguage() {
            return this.machineLanguage;
        }

        public IFile getMachineFile() {
            return this.file;
        }
    }

    private static class MachineLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private MachineLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof MachineEntry) {
                MachineEntry currentEntry = (MachineEntry)element;
                switch (columnIndex) {
                    case 0: {
                        return currentEntry.getMachineName();
                    }
                    case 1: {
                        return currentEntry.getMachineLanguage();
                    }
                }
            }
            return null;
        }
    }

    private static class MachineList {
        private final ArrayList<MachineEntry> entries = new ArrayList();

        private MachineList() {
        }

        public MachineEntry[] getChildren() {
            return this.entries.toArray(new MachineEntry[this.entries.size()]);
        }

        public void addEntry(MachineEntry entry) {
            if (!this.entries.contains(entry)) {
                this.entries.add(entry);
            }
        }

        public void clearList() {
            this.entries.clear();
        }
    }
}

