/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.handler;

import de.bmotionstudio.gef.editor.BMotionEditorPlugin;
import de.bmotionstudio.gef.editor.BMotionStudioEditor;
import de.bmotionstudio.gef.editor.internal.VisualizationProgressBar;
import de.prob.core.Animator;
import de.prob.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public class StartVisualizationFileHandler
extends AbstractHandler
implements IHandler {
    private ISelection fSelection;
    private VisualizationProgressBar dpb;
    private BMotionStudioEditor activeEditor;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection ssel;
        this.fSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        BMotionStudioEditor editor = BMotionEditorPlugin.getActiveEditor();
        if (editor != null && BMotionEditorPlugin.getActiveEditor().isDirty() && MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Please confirm", (String)"You made changes in your editor. Do you want to safe before starting visualization?")) {
            BMotionEditorPlugin.getActiveEditor().doSave((IProgressMonitor)new NullProgressMonitor());
        }
        IFile f = null;
        if (this.fSelection instanceof IStructuredSelection && (ssel = (IStructuredSelection)this.fSelection).size() == 1) {
            block8: {
                f = this.getBmsFileFromSelection(ssel);
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(f.getName());
                try {
                    IEditorPart part = page.openEditor((IEditorInput)new FileEditorInput(f), desc.getId());
                    if (part instanceof BMotionStudioEditor) {
                        this.activeEditor = (BMotionStudioEditor)part;
                        break block8;
                    }
                    return null;
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
            Animator animator = Animator.getAnimator();
            IWorkbench workbench = PlatformUI.getWorkbench();
            try {
                workbench.showPerspective("de.bmotionstudio.perspective.run", workbench.getActiveWorkbenchWindow());
            }
            catch (WorkbenchException e) {
                Logger.notifyUser((String)"Error opening BMotion Studio Run perspective.", (Throwable)e);
            }
            if (this.dpb != null) {
                this.dpb.kill();
            }
            this.dpb = new VisualizationProgressBar(Display.getDefault().getActiveShell(), animator, this.activeEditor, f);
            this.dpb.initGuage();
            this.dpb.open();
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }

    protected IFile getBmsFileFromSelection(IStructuredSelection ssel) {
        if (ssel.getFirstElement() instanceof IFile) {
            return (IFile)ssel.getFirstElement();
        }
        return null;
    }
}

