/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.handler;

import de.bmotionstudio.gef.editor.BMotionEditorPlugin;
import de.bmotionstudio.gef.editor.internal.VisualizationProgressBar;
import de.prob.core.Animator;
import de.prob.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class StartVisualizationEditorHandler
extends AbstractHandler
implements IHandler {
    private VisualizationProgressBar dpb;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (BMotionEditorPlugin.getActiveEditor().isDirty() && MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Please confirm", (String)"You made changes in your editor. Do you want to safe before starting visualization?")) {
            BMotionEditorPlugin.getActiveEditor().doSave((IProgressMonitor)new NullProgressMonitor());
        }
        IFile projectFile = BMotionEditorPlugin.getActiveEditor().getVisualization().getProjectFile();
        Animator animator = Animator.getAnimator();
        IWorkbench workbench = PlatformUI.getWorkbench();
        try {
            workbench.showPerspective("de.bmotionstudio.perspective.run", workbench.getActiveWorkbenchWindow());
        }
        catch (WorkbenchException e) {
            Logger.notifyUser((String)"Error opening BMotion Studio Run perspective.", (Throwable)e);
        }
        if (this.dpb != null) {
            this.dpb.kill();
        }
        this.dpb = new VisualizationProgressBar(Display.getDefault().getActiveShell(), animator, BMotionEditorPlugin.getActiveEditor(), projectFile);
        this.dpb.initGuage();
        this.dpb.open();
        return null;
    }
}

