/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.figure;

import de.bmotionstudio.gef.editor.BMotionEditorPlugin;
import de.bmotionstudio.gef.editor.figure.AbstractBMotionFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ShapeFigure
extends AbstractBMotionFigure {
    private int alpha;
    private int outlineAlpha;
    private int shape;
    private Integer fillType;
    private Image img;
    private Color foregroundColor;
    private Color backgroundColor;
    private Image patternImage;
    private Image shadedImage;
    private Pattern pattern;
    private Pattern shadedPattern;
    private Pattern gradientPattern;
    private final Color white = Display.getDefault().getSystemColor(1);
    private static final int FILL_TYPE_FILLED = 0;
    private static final int FILL_TYPE_EMPTY = 1;
    private static final int FILL_TYPE_SHADED = 2;
    private static final int FILL_TYPE_GRADIENT = 3;
    private static final int SHAPE_TYPE_RECTANGLE = 0;
    private static final int SHAPE_TYPE_OVAL = 1;
    private static final int SHAPE_TYPE_TRIANGLE = 2;
    private static final int SHAPE_TYPE_DIAMOND = 3;
    protected int direction = 1;
    protected int orientation = 128;
    protected PointList triangle = new PointList(3);
    protected PointList diamond = new PointList(4);
    private Shape shapeFigure;

    public ShapeFigure() {
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.shapeFigure = new Shape(){

            protected void fillShape(Graphics g) {
                if (!ShapeFigure.this.visible && !ShapeFigure.this.isRunning) {
                    g.setAlpha(35);
                } else {
                    g.setAlpha(ShapeFigure.this.alpha);
                }
                g.setAntialias(1);
                if (ShapeFigure.this.fillType == 3) {
                    if (ShapeFigure.this.gradientPattern != null) {
                        ShapeFigure.this.gradientPattern.dispose();
                    }
                    ShapeFigure.this.gradientPattern = new Pattern((Device)Display.getDefault(), (float)this.getBounds().x, (float)this.getBounds().y, (float)(this.getBounds().x + this.getBounds().width), (float)(this.getBounds().y + this.getBounds().height), this.getBackgroundColor(), this.getForegroundColor());
                    g.setBackgroundPattern(ShapeFigure.this.gradientPattern);
                } else if (ShapeFigure.this.fillType == 2) {
                    Color black = this.getForegroundColor();
                    PaletteData palette = new PaletteData(new RGB[]{ShapeFigure.this.white.getRGB(), black.getRGB()});
                    ImageData sourceData = new ImageData(11, 11, 1, palette);
                    int i = 0;
                    while (i < 11) {
                        sourceData.setPixel(6, i, 1);
                        ++i;
                    }
                    if (ShapeFigure.this.shadedImage != null) {
                        ShapeFigure.this.shadedImage.dispose();
                    }
                    ShapeFigure.this.shadedImage = new Image((Device)Display.getDefault(), sourceData);
                    if (ShapeFigure.this.shadedPattern != null) {
                        ShapeFigure.this.shadedPattern.dispose();
                    }
                    ShapeFigure.this.shadedPattern = new Pattern((Device)Display.getDefault(), ShapeFigure.this.shadedImage);
                    g.setBackgroundPattern(ShapeFigure.this.shadedPattern);
                } else if (ShapeFigure.this.fillType == 0 && ShapeFigure.this.img != null) {
                    double zoom = 1.0;
                    if (BMotionEditorPlugin.getActiveEditor() != null) {
                        zoom = BMotionEditorPlugin.getActiveEditor().getZoomFactor();
                    }
                    ImageData d = ShapeFigure.this.img.getImageData().scaledTo((int)((double)ShapeFigure.this.img.getBounds().width * zoom), (int)((double)ShapeFigure.this.img.getBounds().height * zoom));
                    if (ShapeFigure.this.patternImage != null) {
                        ShapeFigure.this.patternImage.dispose();
                    }
                    ShapeFigure.this.patternImage = new Image((Device)Display.getDefault(), d);
                    if (ShapeFigure.this.pattern != null) {
                        ShapeFigure.this.pattern.dispose();
                    }
                    ShapeFigure.this.pattern = new Pattern((Device)Display.getDefault(), ShapeFigure.this.patternImage);
                    g.setBackgroundPattern(ShapeFigure.this.pattern);
                } else if (ShapeFigure.this.fillType == 0) {
                    g.setBackgroundColor(this.getBackgroundColor());
                }
                switch (ShapeFigure.this.shape) {
                    case 0: {
                        g.fillRectangle(this.getBounds());
                        break;
                    }
                    case 1: {
                        g.fillOval(this.getBounds().x, this.getBounds().y, this.getBounds().width - 3, this.getBounds().height - 3);
                        break;
                    }
                    case 2: {
                        g.fillPolygon(ShapeFigure.this.triangle);
                        break;
                    }
                    case 3: {
                        g.fillPolygon(ShapeFigure.this.diamond);
                        break;
                    }
                }
            }

            protected void outlineShape(Graphics g) {
                if (!ShapeFigure.this.visible && !ShapeFigure.this.isRunning) {
                    g.setAlpha(35);
                } else {
                    g.setAlpha(ShapeFigure.this.outlineAlpha);
                }
                g.setAntialias(1);
                g.setForegroundColor(this.getForegroundColor());
                float lineInset = Math.max(1.0f, this.getLineWidthFloat()) / 2.0f;
                int inset1 = (int)Math.floor(lineInset);
                int inset2 = (int)Math.ceil(lineInset);
                Rectangle r = Rectangle.SINGLETON.setBounds(this.getBounds());
                r.x += inset1;
                r.y += inset1;
                r.width -= inset1 + inset2;
                r.height -= inset1 + inset2;
                switch (ShapeFigure.this.shape) {
                    case 0: {
                        g.drawRectangle(r);
                        break;
                    }
                    case 1: {
                        r.width -= 2;
                        r.height -= 2;
                        g.drawOval(r);
                        break;
                    }
                    case 2: {
                        g.drawPolygon(ShapeFigure.this.triangle);
                        break;
                    }
                    case 3: {
                        g.drawPolygon(ShapeFigure.this.diamond);
                        break;
                    }
                }
            }
        };
        this.add((IFigure)this.shapeFigure);
    }

    public void setDirection(int value) {
        this.orientation = (value & 5) != 0 ? 128 : 64;
        this.direction = value;
        this.revalidate();
        this.repaint();
    }

    public void setOrientation(int value) {
        if (this.orientation == 128 && value == 64) {
            if (this.direction == 1) {
                this.setDirection(8);
            } else {
                this.setDirection(16);
            }
        }
        if (this.orientation == 64 && value == 128) {
            if (this.direction == 8) {
                this.setDirection(1);
            } else {
                this.setDirection(4);
            }
        }
    }

    public void validate() {
        super.validate();
        Rectangle r = new Rectangle();
        r.setBounds(this.getBounds());
        r.crop(this.getInsets());
        r.resize(-1, -1);
        switch (this.shape) {
            case 2: {
                Point p3;
                Point p2;
                Point head;
                int size;
                switch (this.direction & 5) {
                    case 0: {
                        size = Math.min(r.height / 2, r.width);
                        r.x += (r.width - size) / 2;
                        break;
                    }
                    default: {
                        size = Math.min(r.height, r.width / 2);
                        r.y += (r.height - size) / 2;
                    }
                }
                size = Math.max(size, 1);
                switch (this.direction) {
                    case 1: {
                        head = new Point(r.x + r.width / 2, r.y);
                        p2 = new Point(head.x - size, head.y + size);
                        p3 = new Point(head.x + size, head.y + size);
                        break;
                    }
                    case 4: {
                        head = new Point(r.x + r.width / 2, r.y + size);
                        p2 = new Point(head.x - size, head.y - size);
                        p3 = new Point(head.x + size, head.y - size);
                        break;
                    }
                    case 8: {
                        head = new Point(r.x, r.y + r.height / 2);
                        p2 = new Point(head.x + size, head.y - size);
                        p3 = new Point(head.x + size, head.y + size);
                        break;
                    }
                    default: {
                        head = new Point(r.x + size, r.y + r.height / 2);
                        p2 = new Point(head.x - size, head.y - size);
                        p3 = new Point(head.x - size, head.y + size);
                    }
                }
                this.triangle.removeAllPoints();
                this.triangle.addPoint(head);
                this.triangle.addPoint(p2);
                this.triangle.addPoint(p3);
                break;
            }
            case 3: {
                Point pt1 = new Point(r.x + r.width / 2, r.y);
                Point pt2 = new Point(r.x + r.width, r.y + r.height / 2);
                Point pt3 = new Point(r.x + r.width / 2, r.y + r.height);
                Point pt4 = new Point(r.x, r.y + r.height / 2);
                this.diamond.removeAllPoints();
                this.diamond.addPoint(pt1);
                this.diamond.addPoint(pt2);
                this.diamond.addPoint(pt3);
                this.diamond.addPoint(pt4);
                break;
            }
        }
    }

    public void primTranslate(int dx, int dy) {
        super.primTranslate(dx, dy);
        switch (this.shape) {
            case 2: {
                this.triangle.translate(dx, dy);
                break;
            }
            case 3: {
                this.diamond.translate(dx, dy);
                break;
            }
        }
    }

    public void setBackgroundColor(RGB rgb) {
        if (this.backgroundColor != null) {
            this.backgroundColor.dispose();
        }
        this.backgroundColor = new Color((Device)Display.getDefault(), rgb);
        this.shapeFigure.setBackgroundColor(this.backgroundColor);
    }

    public void setForegroundColor(RGB rgb) {
        if (this.foregroundColor != null) {
            this.foregroundColor.dispose();
        }
        this.foregroundColor = new Color((Device)Display.getDefault(), rgb);
        this.shapeFigure.setForegroundColor(this.foregroundColor);
        this.shapeFigure.repaint();
    }

    public void setLayout(Rectangle rect) {
        this.getParent().setConstraint((IFigure)this, (Object)rect);
    }

    public void setShape(int shape) {
        this.shape = shape;
        this.revalidate();
        this.shapeFigure.repaint();
    }

    public int getShape() {
        return this.shape;
    }

    public Integer getAlpha() {
        return this.alpha;
    }

    public void setAlpha(Integer alpha) {
        this.alpha = alpha;
        this.repaint();
    }

    public Integer getOutlineAlpha() {
        return this.outlineAlpha;
    }

    public void setOutlineAlpha(Integer outlineAlpha) {
        this.outlineAlpha = outlineAlpha;
        this.repaint();
    }

    public void setFillType(Integer fillType) {
        if (fillType == 1) {
            this.shapeFigure.setFill(false);
        } else {
            this.shapeFigure.setFill(true);
        }
        this.fillType = fillType;
        this.repaint();
    }

    public void setImage(Image img) {
        this.img = img;
        this.repaint();
    }

    @Override
    public void deactivateFigure() {
        if (this.img != null) {
            this.img.dispose();
        }
        if (this.foregroundColor != null) {
            this.foregroundColor.dispose();
        }
        if (this.backgroundColor != null) {
            this.backgroundColor.dispose();
        }
        if (this.patternImage != null) {
            this.patternImage.dispose();
        }
        if (this.shadedImage != null) {
            this.shadedImage.dispose();
        }
        if (this.pattern != null) {
            this.pattern.dispose();
        }
        if (this.shadedPattern != null) {
            this.shadedPattern.dispose();
        }
        if (this.gradientPattern != null) {
            this.gradientPattern.dispose();
        }
    }
}

