/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.figure;

import de.bmotionstudio.gef.editor.figure.AbstractBMotionFigure;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;

public class BMSImageFigure
extends AbstractBMotionFigure {
    private ImageFigure imageFigure;
    private int alpha;
    final ImageLoader loader = new ImageLoader();
    private Map<String, List<Image>> images = new HashMap<String, List<Image>>();
    private GIFThread currentGIFThread;

    public BMSImageFigure() {
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.imageFigure = new ImageFigure();
        this.add((IFigure)this.imageFigure);
    }

    public void setLayout(Rectangle rect) {
        this.getParent().setConstraint((IFigure)this.imageFigure, (Object)rect);
    }

    @Override
    public void paint(Graphics g) {
        g.setAlpha(this.alpha);
        super.paint(g);
    }

    public void setImage(String myPath) {
        if (this.currentGIFThread != null) {
            this.currentGIFThread.interrupt();
        }
        if (new File(myPath).exists()) {
            this.loader.load(myPath);
            List<Image> imgList = this.images.get(myPath);
            if (imgList == null) {
                imgList = new ArrayList<Image>();
                ImageData[] imageDataArray = this.loader.data;
                int n = this.loader.data.length;
                int n2 = 0;
                while (n2 < n) {
                    ImageData imageData = imageDataArray[n2];
                    imgList.add(new Image((Device)Display.getDefault(), imageData));
                    ++n2;
                }
                this.images.put(myPath, imgList);
            }
            if (this.loader.data.length > 1) {
                this.currentGIFThread = new GIFThread(this.imageFigure, myPath, imgList);
                this.currentGIFThread.start();
            } else {
                this.imageFigure.setImage(imgList.get(0));
            }
        }
    }

    @Override
    public void deactivateFigure() {
        if (this.currentGIFThread != null) {
            this.currentGIFThread.interrupt();
        }
        if (this.imageFigure.getImage() != null) {
            this.imageFigure.getImage().dispose();
        }
        for (List<Image> l : this.images.values()) {
            for (Image img : l) {
                img.dispose();
            }
        }
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        this.repaint();
    }

    class GIFThread
    extends Thread {
        ImageFigure imgFigure;
        int imageNumber;
        final ImageLoader loader = new ImageLoader();
        boolean stopped = false;
        List<Image> imgList;

        public GIFThread(ImageFigure imgFigure, String imgPath, List<Image> imgList) {
            this.imgFigure = imgFigure;
            this.imgList = imgList;
            this.loader.load(imgPath);
        }

        @Override
        public void run() {
            this.stopped = false;
            while (!this.stopped) {
                int delayTime = this.loader.data[this.imageNumber].delayTime;
                try {
                    Thread.sleep(delayTime * 10);
                }
                catch (InterruptedException interruptedException) {}
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GIFThread.this.imageNumber = GIFThread.this.imageNumber == GIFThread.this.loader.data.length - 1 ? 0 : GIFThread.this.imageNumber + 1;
                        Image image = GIFThread.this.imgList.get(GIFThread.this.imageNumber);
                        if (image != null && !image.isDisposed() && !GIFThread.this.stopped) {
                            GIFThread.this.imgFigure.setImage(image);
                        }
                    }
                });
            }
        }

        @Override
        public void interrupt() {
            this.stopped = true;
            super.interrupt();
        }
    }
}

