/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.edit;

import de.bmotionstudio.gef.editor.attribute.AbstractAttribute;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.observer.ObserverEvalObject;
import de.bmotionstudio.gef.editor.util.BMotionWizardUtil;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class AttributeExpressionEdittingSupport
extends EditingSupport {
    private CellEditor cellEditor;
    private BControl control;
    private String stdAttribute;

    public AttributeExpressionEdittingSupport(ColumnViewer viewer, BControl control) {
        this(viewer, control, null);
    }

    public AttributeExpressionEdittingSupport(ColumnViewer viewer, BControl control, String stdAttribute) {
        super(viewer);
        this.control = control;
        this.stdAttribute = stdAttribute;
    }

    protected boolean canEdit(Object element) {
        return BMotionWizardUtil.isEditElement(this.getViewer());
    }

    protected Object getValue(Object element) {
        ObserverEvalObject evalObject = (ObserverEvalObject)element;
        return evalObject.getValue();
    }

    protected void setValue(Object element, Object value) {
        if (value == null) {
            return;
        }
        ((ObserverEvalObject)element).setValue(value);
    }

    protected CellEditor getCellEditor(Object element) {
        ObserverEvalObject obj = (ObserverEvalObject)element;
        if (obj.isExpressionMode().booleanValue()) {
            if (this.cellEditor == null) {
                this.cellEditor = new TextCellEditor((Composite)this.getViewer().getControl());
            }
            return this.cellEditor;
        }
        String atrID = this.stdAttribute;
        if (atrID == null) {
            atrID = obj.getAttribute();
        }
        if (atrID != null && atrID.length() > 0) {
            AbstractAttribute atr = this.getControl().getAttributes().get(atrID);
            PropertyDescriptor desc = atr.getPropertyDescriptor();
            return desc.createPropertyEditor((Composite)this.getViewer().getControl());
        }
        return null;
    }

    public void setControl(BControl control) {
        this.control = control;
    }

    public BControl getControl() {
        return this.control;
    }

    public void setStdAttribute(String stdAttribute) {
        this.stdAttribute = stdAttribute;
    }

    public String getStdAttribute() {
        return this.stdAttribute;
    }
}

