/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.command;

import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.observer.Observer;
import org.eclipse.gef.commands.Command;

public class SetObserverCommand
extends Command {
    private Observer oldObserver;
    private Observer newObserver;
    private Observer clonedNewObserver;
    private BControl control;

    public void execute() {
        try {
            this.clonedNewObserver = this.newObserver.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        this.control.addObserver(this.newObserver);
    }

    public boolean canExecute() {
        return this.newObserver != null && this.control != null;
    }

    public void undo() {
        if (this.oldObserver != null) {
            this.control.addObserver(this.oldObserver);
        } else {
            this.control.removeObserver(this.newObserver);
        }
    }

    public void redo() {
        this.control.addObserver(this.clonedNewObserver);
    }

    public void setControl(BControl control) {
        this.control = control;
    }

    public BControl getControl() {
        return this.control;
    }

    public Observer getOldObserver() {
        return this.oldObserver;
    }

    public void setOldObserver(Observer oldObserver) {
        this.oldObserver = oldObserver;
    }

    public Observer getNewObserver() {
        return this.newObserver;
    }

    public void setNewObserver(Observer newObserver) {
        this.newObserver = newObserver;
    }
}

