/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.command;

import de.bmotionstudio.gef.editor.command.CopyPasteHelper;
import de.bmotionstudio.gef.editor.model.BConnection;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.model.Visualization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.Clipboard;

public class PasteCommand
extends Command {
    private CopyPasteHelper cHelper;
    private HashMap<BControl, BControl> mappingControl = new HashMap();
    private HashMap<BConnection, BConnection> mappingConnection = new HashMap();
    private List<BControl> parentControls = new ArrayList<BControl>();

    public boolean canExecute() {
        this.cHelper = (CopyPasteHelper)Clipboard.getDefault().getContents();
        if (this.cHelper == null) {
            return false;
        }
        ArrayList<BControl> myList = this.cHelper.getList();
        if (myList.isEmpty()) {
            return false;
        }
        for (BControl node : myList) {
            if (!this.isPastableControl(node)) continue;
            this.mappingControl.put(node, null);
        }
        return true;
    }

    public boolean addElement(BControl control) {
        if (!this.parentControls.contains(control)) {
            return this.parentControls.add(control);
        }
        return false;
    }

    public boolean isContainer(BControl control) {
        return control.canHaveChildren();
    }

    public void execute() {
        if (!this.canExecute()) {
            return;
        }
        try {
            for (BControl parent : this.parentControls) {
                for (BControl control : this.mappingControl.keySet()) {
                    control.setParent(parent);
                    BControl clone = control.clone();
                    clone.setParent(parent);
                    int x = Integer.valueOf(clone.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeX").toString());
                    int y = Integer.valueOf(clone.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeY").toString());
                    clone.setAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeX", x + this.cHelper.getDistance());
                    clone.setAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeY", y + this.cHelper.getDistance());
                    this.mappingControl.put(control, clone);
                    this.cHelper.setDistance(this.cHelper.getDistance() + 10);
                }
                HashMap<BControl, BControl> helpMap = new HashMap<BControl, BControl>();
                helpMap.putAll(this.cHelper.getAlreadyClonedMap());
                helpMap.putAll(this.mappingControl);
                for (BControl control : helpMap.keySet()) {
                    for (BConnection c : control.getSourceConnections()) {
                        this.copyPasteConnection(c, helpMap);
                    }
                    for (BConnection c : control.getTargetConnections()) {
                        this.copyPasteConnection(c, helpMap);
                    }
                }
                this.redo();
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    private void copyPasteConnection(BConnection c, HashMap<BControl, BControl> controlMap) throws CloneNotSupportedException {
        BControl s;
        BControl t;
        BConnection newConnection = this.mappingConnection.get(c);
        if (newConnection == null) {
            newConnection = (BConnection)c.clone();
            newConnection.disconnect();
            this.mappingConnection.put(c, newConnection);
        }
        if ((t = controlMap.get(newConnection.getTarget())) == null) {
            t = newConnection.getTarget();
        }
        if ((s = controlMap.get(newConnection.getSource())) == null) {
            s = newConnection.getSource();
        }
        newConnection.setTarget(t);
        newConnection.setSource(s);
    }

    public void redo() {
        for (BControl control : this.mappingControl.values()) {
            if (!this.isPastableControl(control)) continue;
            control.getParent().addChild(control);
        }
        for (BConnection connection : this.mappingConnection.values()) {
            connection.reconnect();
        }
    }

    public boolean canUndo() {
        return !this.mappingControl.isEmpty();
    }

    public void undo() {
        for (BControl bcontrol : this.mappingControl.values()) {
            if (!this.isPastableControl(bcontrol)) continue;
            bcontrol.getParent().removeChild(bcontrol);
        }
        for (BConnection connection : this.mappingConnection.values()) {
            connection.disconnect();
        }
    }

    public boolean isPastableControl(BControl control) {
        return !(control instanceof Visualization);
    }

    public HashMap<BControl, BControl> getList() {
        return this.mappingControl;
    }
}

