/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.command;

import de.bmotionstudio.gef.editor.model.BControl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class FitImageCommand
extends Command {
    private List<BControl> modelList = new ArrayList<BControl>();
    private Map<BControl, Rectangle> oldSizeMap = new HashMap<BControl, Rectangle>();
    private Map<BControl, Rectangle> newSizeMap = new HashMap<BControl, Rectangle>();

    public boolean canExecute() {
        return this.check();
    }

    public void execute() {
        for (BControl control : this.modelList) {
            this.oldSizeMap.put(control, control.getLayout());
            control.setLayout(this.newSizeMap.get(control));
        }
    }

    public boolean canUndo() {
        if (this.oldSizeMap.isEmpty()) {
            return false;
        }
        return this.check();
    }

    public void undo() {
        for (BControl control : this.modelList) {
            control.setLayout(this.oldSizeMap.get(control));
        }
    }

    public void setModelList(List<BControl> modelList) {
        this.modelList = modelList;
    }

    public void setNewSizeMap(Map<BControl, Rectangle> newSizeMap) {
        this.newSizeMap = newSizeMap;
    }

    private boolean check() {
        if (this.modelList.isEmpty() || this.newSizeMap.isEmpty()) {
            return false;
        }
        for (BControl control : this.modelList) {
            if (control.hasAttribute("de.bmotionstudio.gef.editor.attribute.BAttributeImage")) continue;
            return false;
        }
        return true;
    }
}

