/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.command;

import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.model.BMotionGuide;
import de.bmotionstudio.gef.editor.model.BMotionRuler;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.gef.commands.Command;

public class DeleteGuideCommand
extends Command {
    private BMotionRuler parent;
    private BMotionGuide guide;
    private HashMap<BControl, Integer> oldParts;

    public DeleteGuideCommand(BMotionGuide guide, BMotionRuler parent) {
        super("Delete Guide");
        this.guide = guide;
        this.parent = parent;
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        this.oldParts = new HashMap<BControl, Integer>(this.guide.getMap());
        Iterator<BControl> iter = this.oldParts.keySet().iterator();
        while (iter.hasNext()) {
            this.guide.detachPart(iter.next());
        }
        this.parent.removeGuide(this.guide);
    }

    public void undo() {
        this.parent.addGuide(this.guide);
        for (BControl part : this.oldParts.keySet()) {
            this.guide.attachPart(part, this.oldParts.get(part));
        }
    }
}

