/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.command;

import de.bmotionstudio.gef.editor.model.BConnection;
import de.bmotionstudio.gef.editor.model.BControl;
import org.eclipse.gef.commands.Command;

public class ConnectionReconnectCommand
extends Command {
    private BConnection connection;
    private BControl newSource;
    private BControl newTarget;
    private BControl oldSource;
    private BControl oldTarget;

    public boolean canExecute() {
        if (this.newSource != null) {
            return this.checkSourceReconnection();
        }
        if (this.newTarget != null) {
            return this.checkTargetReconnection();
        }
        return false;
    }

    private boolean checkSourceReconnection() {
        if (this.newSource.equals(this.oldTarget)) {
            return false;
        }
        for (BConnection conn : this.newSource.getSourceConnections()) {
            if (!conn.getTarget().equals(this.oldTarget) || conn.equals(this.connection)) continue;
            return false;
        }
        return true;
    }

    private boolean checkTargetReconnection() {
        if (this.newTarget.equals(this.oldSource)) {
            return false;
        }
        for (BConnection conn : this.newTarget.getTargetConnections()) {
            if (!conn.getSource().equals(this.oldSource) || conn.equals(this.connection)) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        if (this.newSource != null) {
            this.connection.reconnect(this.newSource, this.oldTarget);
        } else if (this.newTarget != null) {
            this.connection.reconnect(this.oldSource, this.newTarget);
        } else {
            throw new IllegalStateException("Should not happen");
        }
    }

    public void setNewSource(BControl connectionSource) {
        if (connectionSource == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel("move connection startpoint");
        this.newSource = connectionSource;
        this.newTarget = null;
    }

    public BControl getNewSource() {
        return this.newSource;
    }

    public void setNewTarget(BControl connectionTarget) {
        if (connectionTarget == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel("move connection endpoint");
        this.newSource = null;
        this.newTarget = connectionTarget;
    }

    public BControl getNewTarget() {
        return this.newTarget;
    }

    public void undo() {
        this.connection.reconnect(this.oldSource, this.oldTarget);
    }

    public void setConnection(BConnection conn) {
        this.connection = conn;
        this.oldSource = conn.getSource();
        this.oldTarget = conn.getTarget();
    }

    public BConnection getConnection() {
        return this.connection;
    }
}

