/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.command;

import de.bmotionstudio.gef.editor.model.BConnection;
import de.bmotionstudio.gef.editor.model.BControl;
import org.eclipse.gef.commands.Command;

public class ConnectionCreateCommand
extends Command {
    private BConnection connection;
    private final BControl source;
    private BControl target;

    public ConnectionCreateCommand(BControl source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel("connection creation");
        this.source = source;
    }

    public boolean canExecute() {
        if (this.source.equals(this.target)) {
            return false;
        }
        for (BConnection conn : this.source.getSourceConnections()) {
            if (!conn.getTarget().equals(this.target)) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        this.connection.setSource(this.source);
        this.connection.setTarget(this.target);
        this.connection.reconnect();
    }

    public void redo() {
        this.connection.reconnect();
    }

    public void setTarget(BControl target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        this.target = target;
    }

    public void undo() {
        this.connection.disconnect();
    }

    public void setConnection(BConnection con) {
        this.connection = con;
    }

    public BConnection getConnection() {
        return this.connection;
    }

    public BControl getSource() {
        return this.source;
    }

    public BControl getTarget() {
        return this.target;
    }
}

