/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.action;

import de.bmotionstudio.gef.editor.action.RenameWizard;
import de.bmotionstudio.gef.editor.model.BControl;
import java.util.HashMap;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class RenameAction
extends SelectionAction {
    public static final String ID = ActionFactory.RENAME.getId();

    public RenameAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(false);
    }

    protected void init() {
        this.setText("Rename...");
        this.setToolTipText("Rename");
        this.setId(ID);
        ImageDescriptor icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"de.bmotionstudio.gef.editor", (String)"icons/icon_rename.png");
        if (icon != null) {
            this.setImageDescriptor(icon);
        }
        this.setEnabled(false);
    }

    protected boolean calculateEnabled() {
        Command cmd = this.createRenameCommand("");
        return cmd != null;
    }

    public Command createRenameCommand(String name) {
        Request renameReq = new Request((Object)"rename");
        HashMap<String, String> reqData = new HashMap<String, String>();
        reqData.put("newName", name);
        renameReq.setExtendedData(reqData);
        if (this.getSelectedObjects().size() > 0 && this.getSelectedObjects().get(0) instanceof EditPart) {
            EditPart object = (EditPart)this.getSelectedObjects().get(0);
            Command cmd = object.getCommand(renameReq);
            return cmd;
        }
        return null;
    }

    public void run() {
        BControl bcontrol = this.getSelectedBControl();
        RenameWizard wizard = new RenameWizard(bcontrol.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeText").toString());
        WizardDialog dialog = new WizardDialog(this.getWorkbenchPart().getSite().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(400, 315);
        dialog.getShell().setText("BMotion Studio Rename Wizard");
        if (dialog.open() == 0) {
            String name = wizard.getRenameValue();
            this.execute(this.createRenameCommand(name));
        }
    }

    private BControl getSelectedBControl() {
        List objects = this.getSelectedObjects();
        if (objects.isEmpty()) {
            return null;
        }
        if (!(objects.get(0) instanceof EditPart)) {
            return null;
        }
        EditPart part = (EditPart)objects.get(0);
        return (BControl)part.getModel();
    }
}

