/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor;

import de.prob.core.IAnimationListener;
import de.prob.core.IComputationListener;
import de.prob.core.ILifecycleListener;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import java.util.HashSet;
import java.util.Set;

public class StaticListenerRegistry
implements ILifecycleListener,
IComputationListener,
IAnimationListener {
    private static final Set<ILifecycleListener> lifeCycleListeners = new HashSet<ILifecycleListener>();
    private static final Set<IComputationListener> computationListeners = new HashSet<IComputationListener>();
    private static final Set<IAnimationListener> animationListeners = new HashSet<IAnimationListener>();

    public static void registerListener(ILifecycleListener listener) {
        lifeCycleListeners.add(listener);
    }

    public static void unregisterListener(ILifecycleListener listener) {
        lifeCycleListeners.remove(listener);
    }

    public static void registerListener(IComputationListener listener) {
        computationListeners.add(listener);
    }

    public static void unregisterListener(IComputationListener listener) {
        computationListeners.remove(listener);
    }

    public static void registerListener(IAnimationListener listener) {
        animationListeners.add(listener);
    }

    public static void unregisterListener(IAnimationListener listener) {
        animationListeners.remove(listener);
    }

    public void reset() {
        for (ILifecycleListener listener : lifeCycleListeners) {
            listener.reset();
        }
    }

    public void computedState(State state) {
        for (IComputationListener listener : computationListeners) {
            listener.computedState(state);
        }
    }

    public void currentStateChanged(State currentState, Operation operation) {
        for (IAnimationListener listener : animationListeners) {
            listener.currentStateChanged(currentState, operation);
        }
    }
}

