/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor;

import de.bmotionstudio.gef.editor.model.Visualization;
import de.bmotionstudio.gef.editor.part.BMSEditPartFactory;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class BMotionStudioRunPage
extends GraphicalEditor {
    private Visualization visualization;
    private KeyHandler keyHandler;

    public BMotionStudioRunPage(Visualization visualization) {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.visualization = visualization;
    }

    public Object getAdapter(Class type) {
        if (type == ZoomManager.class) {
            return ((ScalableRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        return super.getAdapter(type);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setContents((Object)this.getVisualization());
    }

    public Visualization getVisualization() {
        return this.visualization;
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new BMSEditPartFactory());
        ScalableRootEditPart rootEditPart = new ScalableRootEditPart();
        viewer.setRootEditPart((RootEditPart)rootEditPart);
        ZoomManager manager = rootEditPart.getZoomManager();
        this.getActionRegistry().registerAction((IAction)new ZoomInAction(manager));
        this.getActionRegistry().registerAction((IAction)new ZoomOutAction(manager));
        double[] zoomLevels = new double[]{0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0, 5.0, 10.0, 20.0};
        manager.setZoomLevels(zoomLevels);
        ArrayList<String> zoomContributions = new ArrayList<String>();
        zoomContributions.add(ZoomManager.FIT_ALL);
        zoomContributions.add(ZoomManager.FIT_HEIGHT);
        zoomContributions.add(ZoomManager.FIT_WIDTH);
        manager.setZoomLevelContributions(zoomContributions);
        this.keyHandler = new KeyHandler();
        this.keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
        this.keyHandler.put(KeyStroke.getPressed((char)'+', (int)16777259, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
        this.keyHandler.put(KeyStroke.getPressed((char)'-', (int)16777261, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_out"));
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)0), (Object)MouseWheelZoomHandler.SINGLETON);
        viewer.setKeyHandler(this.keyHandler);
        this.loadProperties();
    }

    public void doSave(IProgressMonitor monitor) {
        throw new IllegalAccessError("No way to enter this method.");
    }

    protected void loadProperties() {
        this.getGraphicalViewer().setProperty("ruler$visibility", (Object)false);
        this.getGraphicalViewer().setProperty("SnapToGeometry.isEnabled", (Object)false);
        this.getGraphicalViewer().setProperty("SnapToGrid.isEnabled", (Object)false);
        this.getGraphicalViewer().setProperty("SnapToGrid.isVisible", (Object)false);
    }

    public ScalableRootEditPart getRootEditPart() {
        return (ScalableRootEditPart)this.getGraphicalViewer().getRootEditPart();
    }

    public boolean isDirty() {
        return false;
    }
}

