/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import de.bmotionstudio.gef.editor.Animation;
import de.bmotionstudio.gef.editor.BMotionEditorPlugin;
import de.bmotionstudio.gef.editor.BMotionStudioEditorPage;
import de.bmotionstudio.gef.editor.BMotionStudioRunPage;
import de.bmotionstudio.gef.editor.IRunPageListener;
import de.bmotionstudio.gef.editor.StaticListenerRegistry;
import de.bmotionstudio.gef.editor.internal.BMSConverter512;
import de.bmotionstudio.gef.editor.model.Visualization;
import de.prob.core.ILifecycleListener;
import de.prob.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BMotionStudioEditor
extends MultiPageEditorPart
implements ILifecycleListener {
    private BMotionStudioEditorPage editPage;
    private BMotionStudioRunPage runPage;
    private Visualization visualization;
    private Animation animation;
    private ArrayList<IRunPageListener> runPageListener = new ArrayList();

    protected void createPages() {
        this.createEditPage();
    }

    private void createEditPage() {
        this.editPage = new BMotionStudioEditorPage(this.getVisualization(), this);
        try {
            int index = this.addPage((IEditorPart)this.editPage, this.getEditorInput());
            this.setPageText(index, "Edit");
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public void createRunPage(Visualization visualization, Animation animation) {
        StaticListenerRegistry.registerListener(this);
        this.animation = animation;
        if (this.runPage != null) {
            this.runPage.dispose();
        }
        this.runPage = new BMotionStudioRunPage(visualization);
        try {
            int index = this.addPage((IEditorPart)this.runPage, this.getEditorInput());
            this.setPageText(index, "Run");
            this.setActivePage(index);
            this.fireRunPageCreatedListener();
        }
        catch (PartInitException partInitException) {}
    }

    public void removeRunPage() {
        this.fireRunPageRemovedListener();
        if (this.runPage != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BMotionStudioEditor.this.removePage(1);
                }
            });
        }
        this.unregister();
    }

    private void fireRunPageCreatedListener() {
        for (IRunPageListener listener : this.runPageListener) {
            listener.runPageCreated(this.runPage);
        }
    }

    private void fireRunPageRemovedListener() {
        for (IRunPageListener listener : this.runPageListener) {
            listener.runPageRemoved(this.runPage);
        }
    }

    public void dispose() {
        this.unregister();
        super.dispose();
    }

    public Visualization getVisualization() {
        return this.visualization;
    }

    public void setDirty(boolean dirty) {
        this.editPage.setDirty(dirty);
    }

    public void init(IEditorSite iSite, IEditorInput iInput) throws PartInitException {
        super.init(iSite, iInput);
        IFile file = ((IFileEditorInput)iInput).getFile();
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(file.getContents());
            NodeList nList = doc.getElementsByTagName("version");
            if (nList.item(0) != null) {
                Element versionElement = (Element)nList.item(0);
                String version = versionElement.getTextContent();
                if (version.equals("5.1.2")) {
                    new BMSConverter512(file);
                }
            } else {
                new BMSConverter512(file);
            }
            InputStream inputStream = file.getContents();
            XStream xstream = new XStream(){

                protected MapperWrapper wrapMapper(MapperWrapper next) {
                    return new MapperWrapper((Mapper)next){

                        public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                            if (definedIn == Object.class) {
                                return false;
                            }
                            return super.shouldSerializeMember(definedIn, fieldName);
                        }
                    };
                }
            };
            BMotionEditorPlugin.setAliases(xstream);
            this.visualization = (Visualization)xstream.fromXML(inputStream);
            this.visualization.setProjectFile(((IFileEditorInput)this.getEditorInput()).getFile());
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public String getPartName() {
        return this.visualization.getProjectFile().getName().replace(".bmso", "") + " (" + this.getVisualization().getMachineName() + " - " + this.getVisualization().getLanguage() + ")";
    }

    public void doSave(IProgressMonitor monitor) {
        this.editPage.doSave(monitor);
    }

    public void doSaveAs() {
        throw new IllegalAccessError("No way to enter this method.");
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void pageChange(int newPageIndex) {
        String newPageString = this.getPageText(newPageIndex);
        if (newPageString.equals("Run")) {
            this.switchPerspective("de.bmotionstudio.perspective.run");
        } else {
            this.switchPerspective("de.bmotionstudio.perspective.edit");
        }
    }

    private void switchPerspective(String id) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        try {
            workbench.showPerspective(id, workbench.getActiveWorkbenchWindow());
        }
        catch (WorkbenchException e) {
            Logger.notifyUser((String)"An error occured while trying to switch the perspective.", (Throwable)e);
        }
    }

    public BMotionStudioEditorPage getEditPage() {
        return this.editPage;
    }

    public BMotionStudioRunPage getRunPage() {
        return this.runPage;
    }

    public void reset() {
        this.removeRunPage();
    }

    private void unregister() {
        this.getVisualization().setIsRunning(false);
        StaticListenerRegistry.unregisterListener(this);
        if (this.animation != null) {
            this.animation.unregister();
        }
    }

    public IEditorPart getCurrentPage() {
        return this.getActiveEditor();
    }

    public void addRunPageListener(IRunPageListener listener) {
        this.runPageListener.add(listener);
    }

    public void removeRunPageListener(IRunPageListener listener) {
        this.runPageListener.remove(listener);
    }

    public double getZoomFactor() {
        switch (this.getActivePage()) {
            case 0: {
                return this.editPage.getRootEditPart().getZoomManager().getZoom();
            }
            case 1: {
                return this.runPage.getRootEditPart().getZoomManager().getZoom();
            }
        }
        return 1.0;
    }

    protected void setActivePage(int pageIndex) {
        super.setActivePage(pageIndex);
        this.getSite().setSelectionProvider(this.editPage.getSite().getSelectionProvider());
    }
}

