/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.util;

import de.bmotionstudio.gef.editor.action.BMotionWizardAddItemAction;
import de.bmotionstudio.gef.editor.action.BMotionWizardDeleteItemsAction;
import de.bmotionstudio.gef.editor.library.AttributeTransfer;
import de.bmotionstudio.gef.editor.observer.wizard.WizardObserverDragListener;
import de.bmotionstudio.gef.editor.observer.wizard.WizardObserverDropListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class BMotionWizardUtil {
    public static boolean isEditElement(ColumnViewer viewer) {
        Object data = viewer.getData("editElement");
        if (data != null) {
            return Boolean.valueOf(data.toString());
        }
        return false;
    }

    public static TableViewer createBMotionWizardTableViewer(Composite parent, Class<?> itemClass, String wizardName) {
        final TableViewer tableViewer = new TableViewer(parent, 67586);
        tableViewer.setData("editElement", (Object)false);
        tableViewer.getTable().setLinesVisible(true);
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLayoutData((Object)new GridData(1808));
        int operations = 3;
        Transfer[] transferTypes = new Transfer[]{AttributeTransfer.getInstance()};
        tableViewer.addDropSupport(operations, transferTypes, (DropTargetListener)new WizardObserverDropListener((Viewer)tableViewer, wizardName));
        tableViewer.addDragSupport(operations, transferTypes, (DragSourceListener)new WizardObserverDragListener(tableViewer));
        MenuManager manager = new MenuManager();
        tableViewer.getControl().setMenu(manager.createContextMenu(tableViewer.getControl()));
        manager.add((IAction)new BMotionWizardDeleteItemsAction(tableViewer));
        manager.add((IAction)new BMotionWizardAddItemAction(tableViewer, itemClass));
        tableViewer.getTable().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                tableViewer.setData("editElement", (Object)false);
            }
        });
        tableViewer.getTable().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                tableViewer.setData("editElement", (Object)true);
                TableItem[] selection = tableViewer.getTable().getSelection();
                if (selection.length != 1) {
                    return;
                }
                TableItem item = tableViewer.getTable().getSelection()[0];
                int i = 0;
                while (i < tableViewer.getTable().getColumnCount()) {
                    if (item.getBounds(i).contains(event.x, event.y)) {
                        tableViewer.editElement(item.getData(), i);
                        tableViewer.setData("editElement", (Object)false);
                        break;
                    }
                    ++i;
                }
            }
        });
        return tableViewer;
    }
}

