/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.scheduler;

import de.bmotionstudio.gef.editor.Animation;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.scheduler.AnimationScriptObject;
import de.bmotionstudio.gef.editor.scheduler.AnimationScriptStep;
import de.bmotionstudio.gef.editor.scheduler.SchedulerEvent;
import de.bmotionstudio.gef.editor.scheduler.SchedulerWizard;
import de.bmotionstudio.gef.editor.scheduler.wizard.WizardExecuteScheduler;
import de.bmotionstudio.gef.editor.util.BMSUtil;
import de.prob.core.Animator;
import de.prob.core.command.ExecuteOperationCommand;
import de.prob.core.command.GetCurrentStateIdCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.exceptions.ProBException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ExecuteAnimationScript
extends SchedulerEvent {
    public static String ID = "de.bmotionstudio.gef.editor.scheduler.ExecuteAnimationScript";
    private List<AnimationScriptObject> list = new ArrayList<AnimationScriptObject>();
    private transient Random random;

    @Override
    public void execute(Animation animation, BControl control) {
        Animator animator = animation.getAnimator();
        for (AnimationScriptObject obj : this.list) {
            if (!Boolean.valueOf(BMSUtil.parsePredicate(obj.getPredicate(), control, animation)).booleanValue()) continue;
            for (AnimationScriptStep step : obj.getSteps()) {
                try {
                    String currentState = GetCurrentStateIdCommand.getID((Animator)animator);
                    List<Operation> operations = BMSUtil.parseOperation(step.getCommand(), step.getParameter(), step.getMaxrandom(), animation, currentState, control);
                    if (operations == null) continue;
                    Operation executeOp = step.isRandom() ? operations.get(this.getRandomizer().nextInt(operations.size())) : operations.get(0);
                    ExecuteOperationCommand.executeOperation((Animator)animator, (Operation)executeOp);
                }
                catch (ProBException e) {
                    e.printStackTrace();
                }
            }
            return;
        }
    }

    @Override
    public SchedulerWizard getWizard(BControl bcontrol) {
        return new WizardExecuteScheduler(bcontrol, this);
    }

    @Override
    public ExecuteAnimationScript clone() throws CloneNotSupportedException {
        ExecuteAnimationScript nse = (ExecuteAnimationScript)super.clone();
        ArrayList<AnimationScriptObject> list = new ArrayList<AnimationScriptObject>();
        for (AnimationScriptObject po : this.getList()) {
            list.add(po.clone());
        }
        nse.setList(list);
        return nse;
    }

    public void setList(List<AnimationScriptObject> list) {
        this.list = list;
    }

    public List<AnimationScriptObject> getList() {
        if (this.list == null) {
            this.list = new ArrayList<AnimationScriptObject>();
        }
        return this.list;
    }

    private Random getRandomizer() {
        if (this.random == null) {
            this.random = new Random();
        }
        return this.random;
    }
}

