/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.scheduler;

import de.bmotionstudio.gef.editor.BindingObject;
import de.bmotionstudio.gef.editor.scheduler.ObserverCallBackObject;
import java.util.ArrayList;

public class AnimationScriptStep
extends BindingObject
implements Cloneable {
    private String command;
    private String parameter;
    private int maxrandom = 1;
    private transient ArrayList<ObserverCallBackObject> callBackList;

    public AnimationScriptStep() {
        this("", "");
    }

    public AnimationScriptStep(String command, String parameter, ArrayList<ObserverCallBackObject> callBackList) {
        this.command = command;
        this.parameter = parameter;
        this.callBackList = callBackList;
    }

    public AnimationScriptStep(String command, String parameter) {
        this(command, parameter, new ArrayList<ObserverCallBackObject>());
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        String oldValue = this.command;
        this.command = command;
        this.firePropertyChange("command", oldValue, this.command);
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        String oldValue = this.parameter;
        this.parameter = parameter;
        this.firePropertyChange("parameter", oldValue, this.parameter);
    }

    public void setCallBackList(ArrayList<ObserverCallBackObject> callBackList) {
        ArrayList<ObserverCallBackObject> oldValue = this.callBackList;
        this.callBackList = callBackList;
        this.firePropertyChange("callBackList", oldValue, this.callBackList);
    }

    public ArrayList<ObserverCallBackObject> getCallBackList() {
        if (this.callBackList == null) {
            this.callBackList = new ArrayList();
        }
        return this.callBackList;
    }

    public void addCallBackObject(ObserverCallBackObject callBackObj) {
        this.callBackList.add(callBackObj);
    }

    public void removeCallBackObject(ObserverCallBackObject callBackObj) {
        this.callBackList.remove(callBackObj);
    }

    @Override
    public AnimationScriptStep clone() throws CloneNotSupportedException {
        ArrayList<ObserverCallBackObject> tmpList = new ArrayList<ObserverCallBackObject>();
        for (ObserverCallBackObject p : this.getCallBackList()) {
            tmpList.add(p.clone());
        }
        AnimationScriptStep tmpObj = (AnimationScriptStep)super.clone();
        tmpObj.setCallBackList(tmpList);
        return tmpObj;
    }

    public int getMaxrandom() {
        return this.maxrandom;
    }

    public void setMaxrandom(int maxrandom) {
        Integer oldValue = this.maxrandom;
        this.maxrandom = maxrandom;
        this.firePropertyChange("maxrandom", oldValue, this.maxrandom);
    }

    public boolean isRandom() {
        return this.maxrandom > 1;
    }
}

