/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.property;

import java.text.MessageFormat;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Slider;

public class SliderCellEditor
extends CellEditor {
    private Composite editor;
    private Slider slider;
    private Label countLabel;
    private FocusListener buttonFocusListener;
    private Object value = null;
    private static final int defaultStyle = 0;

    public SliderCellEditor() {
        this.setStyle(0);
    }

    public SliderCellEditor(Composite parent) {
        this(parent, 0);
    }

    public SliderCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Slider createSpinner(Composite parent) {
        Slider result = new Slider(parent, 256);
        result.setMaximum(265);
        result.setIncrement(1);
        return result;
    }

    protected Control createControl(Composite parent) {
        Font font = parent.getFont();
        Color bg = parent.getBackground();
        this.editor = new Composite(parent, this.getStyle());
        this.editor.setFont(font);
        this.editor.setBackground(bg);
        this.editor.setLayout((Layout)new SliderSampleCellLayout());
        this.countLabel = new Label(this.editor, 0);
        this.slider = this.createSpinner(this.editor);
        this.slider.setFont(font);
        this.slider.setBackground(this.editor.getBackground());
        this.updateContents(this.value);
        this.slider.addFocusListener(this.getButtonFocusListener());
        this.slider.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SliderCellEditor.this.slider.removeFocusListener(SliderCellEditor.this.getButtonFocusListener());
                Integer newValue = SliderCellEditor.this.slider.getSelection();
                if (newValue != null) {
                    boolean newValidState = SliderCellEditor.this.isCorrect(newValue);
                    if (newValidState) {
                        SliderCellEditor.this.markDirty();
                        SliderCellEditor.this.doSetValue(newValue);
                    } else {
                        SliderCellEditor.this.setErrorMessage(MessageFormat.format(SliderCellEditor.this.getErrorMessage(), ((Object)newValue).toString()));
                    }
                }
            }
        });
        this.slider.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                SliderCellEditor.this.fireApplyEditorValue();
            }
        });
        this.setValueValid(true);
        return this.editor;
    }

    public void deactivate() {
        if (this.slider != null && !this.slider.isDisposed()) {
            this.slider.removeFocusListener(this.getButtonFocusListener());
        }
        super.deactivate();
    }

    protected Object doGetValue() {
        return this.value;
    }

    protected void doSetFocus() {
        this.slider.setFocus();
        this.slider.addFocusListener(this.getButtonFocusListener());
    }

    private FocusListener getButtonFocusListener() {
        if (this.buttonFocusListener == null) {
            this.buttonFocusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    SliderCellEditor.this.focusLost();
                }
            };
        }
        return this.buttonFocusListener;
    }

    protected void doSetValue(Object value) {
        this.value = value;
        this.updateContents(value);
    }

    protected void updateContents(Object value) {
        String text = "";
        if (value != null) {
            text = value.toString();
            if (this.slider != null) {
                this.slider.setSelection(Integer.parseInt(text));
                this.countLabel.setText(value.toString());
            }
        }
    }

    private class SliderSampleCellLayout
    extends Layout {
        private SliderSampleCellLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            SliderCellEditor.this.slider.setBounds(30, 0, bounds.width - 30, bounds.height);
            SliderCellEditor.this.countLabel.setBounds(5, 1, 25, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point buttonSize = SliderCellEditor.this.slider.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, buttonSize.y);
            return result;
        }
    }
}

