/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.observer;

import de.bmotionstudio.gef.editor.Animation;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.observer.Observer;
import de.bmotionstudio.gef.editor.observer.ObserverWizard;
import de.bmotionstudio.gef.editor.observer.ToggleObjectCoordinates;
import de.bmotionstudio.gef.editor.observer.wizard.WizardObserverCSwitchCoordinates;
import de.bmotionstudio.gef.editor.util.BMSUtil;
import java.util.ArrayList;
import java.util.List;

public class SwitchChildCoordinates
extends Observer {
    private List<ToggleObjectCoordinates> toggleObjects = new ArrayList<ToggleObjectCoordinates>();

    @Override
    public void check(Animation animation, BControl control) {
        for (ToggleObjectCoordinates obj : this.toggleObjects) {
            obj.setHasError(false);
            String bolValue = "true";
            if (obj.getEval().length() > 0) {
                bolValue = BMSUtil.parsePredicate(obj.getEval(), control, animation);
            }
            if (obj.hasError().booleanValue() || !Boolean.valueOf(bolValue).booleanValue()) continue;
            BControl toggleControl = null;
            String parsedControl = BMSUtil.parseExpression(obj.getBcontrol(), control, animation, false);
            toggleControl = control.getChild(parsedControl);
            if (toggleControl == null) {
                obj.setHasError(true);
            }
            Integer parsedX = 0;
            Integer parsedY = 0;
            try {
                parsedX = Integer.valueOf(BMSUtil.parseExpression(obj.getX(), control, animation));
            }
            catch (NumberFormatException numberFormatException) {
                obj.setHasError(true);
            }
            try {
                parsedY = Integer.valueOf(BMSUtil.parseExpression(obj.getY(), control, animation));
            }
            catch (NumberFormatException numberFormatException) {
                obj.setHasError(true);
            }
            if (obj.hasError().booleanValue() || !Boolean.valueOf(bolValue).booleanValue()) continue;
            toggleControl.setAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeX", parsedX, true, false);
            toggleControl.setAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeY", parsedY, true, false);
        }
    }

    @Override
    public ObserverWizard getWizard(BControl bcontrol) {
        return new WizardObserverCSwitchCoordinates(bcontrol, this);
    }

    public List<ToggleObjectCoordinates> getToggleObjects() {
        return this.toggleObjects;
    }

    public void setToggleObjects(List<ToggleObjectCoordinates> list) {
        this.toggleObjects = list;
    }

    @Override
    public Observer clone() throws CloneNotSupportedException {
        SwitchChildCoordinates clonedObserver = (SwitchChildCoordinates)super.clone();
        ArrayList<ToggleObjectCoordinates> list = new ArrayList<ToggleObjectCoordinates>();
        for (ToggleObjectCoordinates obj : this.getToggleObjects()) {
            list.add(obj.clone());
        }
        clonedObserver.setToggleObjects(list);
        return clonedObserver;
    }
}

