/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.observer;

import de.bmotionstudio.gef.editor.Animation;
import de.bmotionstudio.gef.editor.attribute.AbstractAttribute;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.observer.Observer;
import de.bmotionstudio.gef.editor.observer.ObserverWizard;
import de.bmotionstudio.gef.editor.observer.SetAttributeObject;
import de.bmotionstudio.gef.editor.observer.wizard.WizardObserverSetAttribute;
import de.bmotionstudio.gef.editor.util.BMSUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;

public class SetAttribute
extends Observer {
    private List<SetAttributeObject> setAttributeObjects = new ArrayList<SetAttributeObject>();
    private transient List<String> setAttributes = new ArrayList<String>();

    @Override
    protected Object readResolve() {
        this.setAttributes = new ArrayList<String>();
        return super.readResolve();
    }

    @Override
    public void check(Animation animation, BControl control) {
        this.setAttributes.clear();
        for (SetAttributeObject obj : this.setAttributeObjects) {
            Object oldAttrVal;
            obj.setHasError(false);
            String bolValue = "true";
            if (obj.getEval().length() > 0) {
                bolValue = BMSUtil.parsePredicate(obj.getEval(), control, animation);
            }
            if (obj.hasError().booleanValue() || !Boolean.valueOf(bolValue).booleanValue()) continue;
            String attributeID = obj.getAttribute();
            AbstractAttribute attributeObj = control.getAttribute(attributeID);
            Object attributeVal = obj.getValue();
            if (obj.isExpressionMode().booleanValue()) {
                String strAtrVal = BMSUtil.parseExpression(attributeVal.toString(), control, animation);
                String er = attributeObj.validateValue(strAtrVal, null);
                if (er != null) {
                    obj.setHasError(true);
                } else {
                    attributeVal = attributeObj.unmarshal(strAtrVal);
                }
            }
            if (!obj.hasError().booleanValue() && !(oldAttrVal = control.getAttributeValue(attributeID)).equals(attributeVal)) {
                control.setAttributeValue(attributeID, attributeVal, true, false);
            }
            this.setAttributes.add(attributeID);
        }
        for (SetAttributeObject obj : this.setAttributeObjects) {
            if (this.setAttributes.contains(obj.getAttribute())) continue;
            AbstractAttribute attributeObj = control.getAttribute(obj.getAttribute());
            Object oldAttrVal = control.getAttributeValue(obj.getAttribute());
            if (oldAttrVal.equals(attributeObj.getInitValue())) continue;
            control.restoreDefaultValue(attributeObj.getID());
        }
    }

    @Override
    public ObserverWizard getWizard(BControl control) {
        return new WizardObserverSetAttribute(control, this);
    }

    public void setSetAttributeObjects(List<SetAttributeObject> setAttributeObjects) {
        this.setAttributeObjects = setAttributeObjects;
    }

    public List<SetAttributeObject> getSetAttributeObjects() {
        return this.setAttributeObjects;
    }

    @Override
    public Observer clone() throws CloneNotSupportedException {
        SetAttribute clonedObserver = (SetAttribute)super.clone();
        ArrayList<SetAttributeObject> list = new ArrayList<SetAttributeObject>();
        for (SetAttributeObject obj : this.getSetAttributeObjects()) {
            list.add(obj.clone());
        }
        clonedObserver.setSetAttributeObjects(list);
        return clonedObserver;
    }

    @Override
    public IFigure getToolTip(BControl control) {
        return null;
    }
}

