/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.model;

import de.bmotionstudio.gef.editor.Animation;
import de.bmotionstudio.gef.editor.BMotionEditorPlugin;
import de.bmotionstudio.gef.editor.BMotionStudioImage;
import de.bmotionstudio.gef.editor.attribute.AbstractAttribute;
import de.bmotionstudio.gef.editor.attribute.BAttributeCoordinates;
import de.bmotionstudio.gef.editor.attribute.BAttributeCustom;
import de.bmotionstudio.gef.editor.attribute.BAttributeHeight;
import de.bmotionstudio.gef.editor.attribute.BAttributeID;
import de.bmotionstudio.gef.editor.attribute.BAttributeMisc;
import de.bmotionstudio.gef.editor.attribute.BAttributeSize;
import de.bmotionstudio.gef.editor.attribute.BAttributeVisible;
import de.bmotionstudio.gef.editor.attribute.BAttributeWidth;
import de.bmotionstudio.gef.editor.attribute.BAttributeX;
import de.bmotionstudio.gef.editor.attribute.BAttributeY;
import de.bmotionstudio.gef.editor.command.CopyPasteHelper;
import de.bmotionstudio.gef.editor.internal.BControlPropertySource;
import de.bmotionstudio.gef.editor.model.BConnection;
import de.bmotionstudio.gef.editor.model.BControlList;
import de.bmotionstudio.gef.editor.model.BMotionGuide;
import de.bmotionstudio.gef.editor.model.Visualization;
import de.bmotionstudio.gef.editor.observer.Observer;
import de.bmotionstudio.gef.editor.scheduler.SchedulerEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;

public abstract class BControl
implements IAdaptable,
Cloneable {
    protected String type;
    private BControlList children;
    private Map<String, Observer> observers;
    private Map<String, SchedulerEvent> events;
    private Map<String, AbstractAttribute> attributes;
    private BMotionGuide verticalGuide;
    private BMotionGuide horizontalGuide;
    private List<BConnection> sourceConnections;
    private List<BConnection> targetConnections;
    private transient Rectangle layout = null;
    private transient Point location = null;
    private transient BControl parent;
    private transient Visualization visualization;
    private transient PropertyChangeSupport listeners;
    private transient boolean newControl;

    public BControl(Visualization visualization) {
        this.visualization = visualization;
        this.children = new BControlList();
        this.observers = new HashMap<String, Observer>();
        this.events = new HashMap<String, SchedulerEvent>();
        this.attributes = new HashMap<String, AbstractAttribute>();
        this.listeners = new PropertyChangeSupport(this);
        this.sourceConnections = new ArrayList<BConnection>();
        this.targetConnections = new ArrayList<BConnection>();
        this.newControl = true;
        this.init();
    }

    protected Object readResolve() {
        for (BControl child : this.getChildrenArray()) {
            child.setParent(this);
        }
        this.newControl = false;
        return this;
    }

    public void removeConnection(BConnection conn) {
        if (conn == null) {
            throw new IllegalArgumentException();
        }
        if (conn.getSource() == this) {
            this.getSourceConnections().remove(conn);
            this.getListeners().firePropertyChange("ControlSourceConn", null, conn);
        } else if (conn.getTarget() == this) {
            this.getTargetConnections().remove(conn);
            this.getListeners().firePropertyChange("ControlTargetConn", null, conn);
        }
    }

    public void addConnection(BConnection conn) {
        if (conn == null || conn.getSource() == conn.getTarget()) {
            throw new IllegalArgumentException();
        }
        if (conn.getSource() == this) {
            this.getSourceConnections().add(conn);
            this.getListeners().firePropertyChange("ControlSourceConn", null, conn);
        } else if (conn.getTarget() == this) {
            this.getTargetConnections().add(conn);
            this.getListeners().firePropertyChange("ControlTargetConn", null, conn);
        }
    }

    protected void init() {
        this.initStandardAttributes();
        this.initAttributes();
    }

    private List<String> getSupportedObserverList() {
        ArrayList<String> supportedObserver = new ArrayList<String>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("de.bmotionstudio.gef.editor.includeObserver");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String langID;
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if ("include".equals(configurationElement.getName()) && (langID = configurationElement.getAttribute("language")) != null && langID.equals(this.getVisualization().getLanguage())) {
                    IConfigurationElement[] iConfigurationElementArray2 = configurationElement.getChildren("control");
                    int n5 = iConfigurationElementArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IConfigurationElement configC = iConfigurationElementArray2[n6];
                        String cID = configC.getAttribute("id");
                        if (this.getType().equals(cID)) {
                            IConfigurationElement[] iConfigurationElementArray3 = configC.getChildren("observer");
                            int n7 = iConfigurationElementArray3.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                IConfigurationElement configO = iConfigurationElementArray3[n8];
                                supportedObserver.add(configO.getAttribute("id"));
                                ++n8;
                            }
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return supportedObserver;
    }

    private void initStandardAttributes() {
        String ID = this instanceof Visualization ? "visualization" : (this.visualization == null ? UUID.randomUUID().toString() : this.visualization.getMaxIDString(this.type));
        BAttributeID aID = new BAttributeID(ID);
        aID.setGroup("de.bmotionstudio.gef.editor.attribute.BAttributeRoot");
        this.initAttribute(aID);
        BAttributeMisc aMisc = new BAttributeMisc("");
        aMisc.setGroup("de.bmotionstudio.gef.editor.attribute.BAttributeRoot");
        this.initAttribute(aMisc);
        BAttributeCoordinates aCoordinates = new BAttributeCoordinates(null);
        aCoordinates.setGroup("de.bmotionstudio.gef.editor.attribute.BAttributeRoot");
        this.initAttribute(aCoordinates);
        BAttributeX aX = new BAttributeX(100);
        aX.setGroup(aCoordinates);
        this.initAttribute(aX);
        BAttributeY aY = new BAttributeY(100);
        aY.setGroup(aCoordinates);
        this.initAttribute(aY);
        BAttributeSize aSize = new BAttributeSize(null);
        aSize.setGroup("de.bmotionstudio.gef.editor.attribute.BAttributeRoot");
        this.initAttribute(aSize);
        BAttributeWidth aWidth = new BAttributeWidth(100);
        aWidth.setGroup(aSize);
        this.initAttribute(aWidth);
        BAttributeHeight aHeight = new BAttributeHeight(100);
        aHeight.setGroup(aSize);
        this.initAttribute(aHeight);
        BAttributeVisible aVisible = new BAttributeVisible(true);
        aVisible.setGroup("de.bmotionstudio.gef.editor.attribute.BAttributeRoot");
        this.initAttribute(aVisible);
        BAttributeCustom aCustom = new BAttributeCustom("");
        aCustom.setGroup("de.bmotionstudio.gef.editor.attribute.BAttributeRoot");
        this.initAttribute(aCustom);
    }

    protected abstract void initAttributes();

    public String getID() {
        return this.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeID").toString();
    }

    public AbstractAttribute getAttribute(String attributeID) {
        return this.getAttributes().get(attributeID);
    }

    public Object getAttributeValue(String attributeID) {
        AbstractAttribute atr = this.attributes.get(attributeID);
        if (atr != null) {
            return atr.getValue();
        }
        return null;
    }

    public boolean setAttributeValue(String attributeID, Object value) {
        return this.setAttributeValue(attributeID, value, true, true);
    }

    public boolean setAttributeValue(String attributeID, Object value, Boolean firePropertyChange) {
        return this.setAttributeValue(attributeID, value, firePropertyChange, true);
    }

    public boolean setAttributeValue(String attributeID, Object value, Boolean firePropertyChange, Boolean setInitVal) {
        AbstractAttribute atr = this.attributes.get(attributeID);
        if (atr == null) {
            return false;
        }
        atr.setControl(this);
        if (atr.getValue() != null && atr.getValue().equals(value) || !atr.isEditable()) {
            return true;
        }
        atr.setValue(value, firePropertyChange, setInitVal);
        return true;
    }

    public void restoreDefaultValue(String attributeID) {
        AbstractAttribute atr = this.attributes.get(attributeID);
        if (atr != null) {
            atr.restoreValue();
            Object oldVal = atr.getValue();
            Object initValue = atr.getInitValue();
            this.getListeners().firePropertyChange(attributeID, oldVal, initValue);
        }
    }

    public boolean hasAttribute(String attributeID) {
        return this.attributes.containsKey(attributeID);
    }

    public void setLayout(Rectangle newLayout) {
        Rectangle oldLayout = this.getLayout();
        this.layout = newLayout;
        this.setAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeX", newLayout.x, false);
        this.setAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeY", newLayout.y, false);
        this.setAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeWidth", newLayout.width, false);
        this.setAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeHeight", newLayout.height, false);
        this.getListeners().firePropertyChange("ControlLayout", oldLayout, newLayout);
    }

    public Rectangle getLayout() {
        String widthStr = this.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeWidth").toString();
        String heightStr = this.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeHeight").toString();
        String xStr = this.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeX").toString();
        String yStr = this.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeY").toString();
        try {
            int width = Integer.valueOf(widthStr);
            int height = Integer.valueOf(heightStr);
            int x = Integer.valueOf(xStr);
            int y = Integer.valueOf(yStr);
            if (this.layout == null) {
                this.layout = new Rectangle(x, y, width, height);
            } else {
                this.layout.x = x;
                this.layout.y = y;
                this.layout.width = width;
                this.layout.height = height;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return this.layout;
    }

    public void setLocation(Point newLocation) {
        Point oldLocation = this.getLocation();
        this.location = newLocation;
        this.setAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeX", newLocation.x, false);
        this.setAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeY", newLocation.y, false);
        this.getListeners().firePropertyChange("ControlLocation", oldLocation, newLocation);
    }

    public Point getLocation() {
        int x = Integer.valueOf(this.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeX").toString());
        int y = Integer.valueOf(this.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeY").toString());
        if (this.location == null) {
            this.location = new Point(x, y);
        } else {
            this.location.x = x;
            this.location.y = y;
        }
        return this.location;
    }

    public Dimension getDimension() {
        int width = Integer.valueOf(this.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeWidth").toString());
        int height = Integer.valueOf(this.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeHeight").toString());
        return new Dimension(width, height);
    }

    public void addChild(BControl child) {
        this.addChild(child, -1);
    }

    public void addChild(BControl child, int index) {
        child.setParent(this);
        if (index >= 0) {
            this.children.add(index, child);
        } else {
            this.children.add(child);
        }
        this.getListeners().firePropertyChange("ControlAddChild", (Object)index, child);
    }

    public void removeAllChildren() {
        this.getChildrenArray().clear();
        this.getListeners().firePropertyChange("ControlRemoveChild", null, null);
    }

    public boolean removeChild(int index) {
        BControl control = (BControl)this.children.get(index);
        return this.removeChild(control);
    }

    public boolean removeChild(BControl child) {
        boolean b = this.children.remove(child);
        if (b) {
            this.getListeners().firePropertyChange("ControlRemoveChild", child, null);
        }
        return b;
    }

    public List<BControl> getChildrenArray() {
        if (this.children == null) {
            this.children = new BControlList();
        }
        return this.children;
    }

    public void setChildrenArray(BControlList children) {
        this.children = children;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public BControl getChild(String ID) {
        for (BControl bcontrol : this.children) {
            String bcontrolID = bcontrol.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeID").toString();
            if (bcontrolID == null || !bcontrolID.equals(ID)) continue;
            return bcontrol;
        }
        return null;
    }

    public Map<String, Observer> getObservers() {
        if (this.observers == null) {
            this.observers = new HashMap<String, Observer>();
        }
        return this.observers;
    }

    public Observer getObserver(String observerID) {
        return this.observers.get(observerID);
    }

    public Boolean hasObserver(String ID) {
        if (this.getObservers().containsKey(ID)) {
            return true;
        }
        return false;
    }

    public void addObserver(Observer observer) {
        this.observers.put(observer.getID(), observer);
        this.getListeners().firePropertyChange("ControlAddObserver", observer, null);
    }

    public void removeObserver(Observer observer) {
        this.removeObserver(observer.getID());
    }

    public void removeObserver(String observerID) {
        Observer o = this.observers.remove(observerID);
        if (o != null) {
            o.beforeDelete(this);
            this.getListeners().firePropertyChange("ControlRemoveObserver", o, null);
        }
    }

    public Map<String, SchedulerEvent> getEvents() {
        if (this.events == null) {
            this.events = new HashMap<String, SchedulerEvent>();
        }
        return this.events;
    }

    public SchedulerEvent getEvent(String ID) {
        return this.events.get(ID);
    }

    public Boolean hasEvent(String ID) {
        if (this.getEvents().containsKey(ID)) {
            return true;
        }
        return false;
    }

    public void addEvent(String eventID, SchedulerEvent schedulerEvent) {
        this.events.put(eventID, schedulerEvent);
        this.getListeners().firePropertyChange("ControlAddEvent", schedulerEvent, null);
    }

    public void removeEvent(String eventID) {
        SchedulerEvent e = this.events.remove(eventID);
        if (e != null) {
            e.beforeDelete(this);
            this.getListeners().firePropertyChange("ControlRemoveEvent", e, null);
        }
    }

    public Map<String, AbstractAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, AbstractAttribute> attributes) {
        this.attributes = attributes;
    }

    public void setParent(BControl parent) {
        this.parent = parent;
    }

    public BControl getParent() {
        return this.parent;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getListeners().addPropertyChangeListener(listener);
    }

    public PropertyChangeSupport getListeners() {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        return this.listeners;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getListeners().removePropertyChangeListener(listener);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            return new BControlPropertySource(this);
        }
        return null;
    }

    public boolean contains(BControl child) {
        return this.children.contains(child);
    }

    public String getDefaultValue(String attributeID) {
        IConfigurationElement configurationElement = BMotionEditorPlugin.getControlExtension(this.getType());
        if (configurationElement != null) {
            IConfigurationElement[] iConfigurationElementArray = configurationElement.getChildren("attributes");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configBAttributes = iConfigurationElementArray[n2];
                IConfigurationElement[] iConfigurationElementArray2 = configBAttributes.getChildren("attribute-string");
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configBAttribute = iConfigurationElementArray2[n4];
                    String aID = configBAttribute.getAttribute("id");
                    if (aID.equals(attributeID)) {
                        String attributeDefaultValue = configBAttribute.getAttribute("default-value");
                        return attributeDefaultValue;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    public Boolean isAttributeEditable(String attributeID) {
        IConfigurationElement configurationElement = BMotionEditorPlugin.getControlExtension(this.getType());
        if (configurationElement != null) {
            IConfigurationElement[] iConfigurationElementArray = configurationElement.getChildren("attributes");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configBAttributes = iConfigurationElementArray[n2];
                IConfigurationElement[] iConfigurationElementArray2 = configBAttributes.getChildren("attribute-string");
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configBAttribute = iConfigurationElementArray2[n4];
                    String aID = configBAttribute.getAttribute("id");
                    if (aID.equals(attributeID)) {
                        String val = configBAttribute.getAttribute("editable");
                        return Boolean.valueOf(val);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return false;
    }

    public Visualization getVisualization() {
        return this.visualization;
    }

    public void setVisualization(Visualization visualization) {
        this.visualization = visualization;
    }

    public BControl clone() throws CloneNotSupportedException {
        BControl clonedControl = (BControl)super.clone();
        clonedControl.listeners = new PropertyChangeSupport(clonedControl);
        clonedControl.sourceConnections = new ArrayList<BConnection>();
        clonedControl.targetConnections = new ArrayList<BConnection>();
        clonedControl.setParent(this.getParent());
        HashMap<String, AbstractAttribute> newProperties = new HashMap<String, AbstractAttribute>();
        for (Map.Entry<String, AbstractAttribute> e : this.getAttributes().entrySet()) {
            AbstractAttribute idAtr = e.getValue().clone();
            newProperties.put(e.getKey(), idAtr);
        }
        clonedControl.setAttributes(newProperties);
        clonedControl.setAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeID", this.getVisualization().getMaxIDString(this.type));
        clonedControl.setChildrenArray(new BControlList());
        for (BControl bControl : this.getChildrenArray()) {
            BControl childClone = bControl.clone();
            CopyPasteHelper cHelper = (CopyPasteHelper)Clipboard.getDefault().getContents();
            if (cHelper != null) {
                cHelper.getAlreadyClonedMap().put(bControl, childClone);
            }
            clonedControl.addChild(childClone);
        }
        clonedControl.setObserverMap(new HashMap<String, Observer>());
        for (Observer observer : this.observers.values()) {
            clonedControl.addObserver(observer.clone());
        }
        clonedControl.setEventMap(new HashMap<String, SchedulerEvent>());
        for (Map.Entry entry : this.events.entrySet()) {
            clonedControl.addEvent((String)entry.getKey(), ((SchedulerEvent)entry.getValue()).clone());
        }
        return clonedControl;
    }

    public void checkObserver(Animation animation) {
        for (Observer observer : this.getObservers().values()) {
            observer.check(animation, this);
        }
        for (BConnection con : this.getSourceConnections()) {
            con.checkObserver(animation);
        }
        for (BConnection con : this.getTargetConnections()) {
            con.checkObserver(animation);
        }
    }

    public void executeEvent(String eventID) {
        if (this.hasAttribute("de.bmotionstudio.gef.editor.attribute.BAttributeEnabled") && !((Boolean)this.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeEnabled")).booleanValue()) {
            return;
        }
        SchedulerEvent e = this.getEvents().get(eventID);
        if (e != null) {
            e.execute(this.getVisualization().getAnimation(), this);
        }
    }

    public void setVerticalGuide(BMotionGuide verticalGuide) {
        this.verticalGuide = verticalGuide;
    }

    public BMotionGuide getVerticalGuide() {
        return this.verticalGuide;
    }

    public void setHorizontalGuide(BMotionGuide horizontalGuide) {
        this.horizontalGuide = horizontalGuide;
    }

    public BMotionGuide getHorizontalGuide() {
        return this.horizontalGuide;
    }

    public List<BConnection> getSourceConnections() {
        if (this.sourceConnections == null) {
            this.sourceConnections = new ArrayList<BConnection>();
        }
        return this.sourceConnections;
    }

    public void setSourceConnections(List<BConnection> connections) {
        this.sourceConnections = connections;
    }

    public void setTargetConnections(List<BConnection> connections) {
        this.targetConnections = connections;
    }

    public List<BConnection> getTargetConnections() {
        if (this.targetConnections == null) {
            this.targetConnections = new ArrayList<BConnection>();
        }
        return this.targetConnections;
    }

    public boolean hasConnections() {
        return !this.getTargetConnections().isEmpty() || !this.getSourceConnections().isEmpty();
    }

    public boolean showInOutlineView() {
        return true;
    }

    public void setObserverMap(Map<String, Observer> observerMap) {
        this.observers = observerMap;
    }

    public void setEventMap(Map<String, SchedulerEvent> eventMap) {
        this.events = eventMap;
    }

    public abstract String getType();

    protected void initAttribute(AbstractAttribute atr) {
        AbstractAttribute oldAtr = this.getAttribute(atr.getID());
        if (oldAtr != null && !this.newControl) {
            atr.setValue(oldAtr.getValue());
            atr.setDefaultValue(oldAtr.getDefaultValue());
        }
        this.getAttributes().put(atr.getID(), atr);
    }

    public boolean canHaveChildren() {
        return false;
    }

    public String getValueOfData() {
        return this.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeCustom").toString();
    }

    public Image getIcon() {
        return BMotionStudioImage.getBControlImage(this.getType());
    }
}

