/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.library;

import de.bmotionstudio.gef.editor.BMotionStudioImage;
import de.bmotionstudio.gef.editor.library.AbstractLibraryAction;
import de.bmotionstudio.gef.editor.library.LibraryPage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;

public class ImportImagesAction
extends AbstractLibraryAction {
    public ImportImagesAction(LibraryPage page) {
        super(page);
        this.setText("Import images...");
        this.setImageDescriptor(BMotionStudioImage.getImageDescriptor("org.eclipse.ui", "$nl$/icons/full/etool16/import_wiz.gif"));
    }

    public void run() {
        FileDialog fd = new FileDialog(Display.getDefault().getActiveShell(), 4098);
        fd.setText("Open");
        fd.setFilterPath("C:/");
        String[] filterExt = new String[]{"*.jpg", "*.gif", "*.png", "*.*"};
        fd.setFilterExtensions(filterExt);
        fd.open();
        String folderPath = fd.getFilterPath();
        String[] selectedFiles = fd.getFileNames();
        IFile pFile = this.getPage().getEditor().getVisualization().getProjectFile();
        try {
            IProject project = pFile.getProject();
            IFolder folder = project.getFolder("images");
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (!folder.exists()) {
                folder.create(true, true, (IProgressMonitor)monitor);
            }
            String[] stringArray = selectedFiles;
            int n = selectedFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                File inputFile = new File(folderPath + File.separator + fileName);
                IFile newFile = folder.getFile(fileName);
                FileInputStream fileInputStream = new FileInputStream(inputFile);
                if (!newFile.exists()) {
                    newFile.create((InputStream)fileInputStream, true, (IProgressMonitor)monitor);
                } else {
                    MessageBox mb = new MessageBox(fd.getParent(), 200);
                    mb.setMessage(fileName + " already exists. Do you want to replace it?");
                    if (mb.open() == 64) {
                        newFile.setContents((InputStream)fileInputStream, true, false, (IProgressMonitor)monitor);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.getPage().refresh();
    }
}

