/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.internal;

import de.bmotionstudio.gef.editor.internal.NewBMotionProjectWizardPage;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.rodinp.core.RodinCore;

public class NewBMotionProjectWizard
extends Wizard
implements INewWizard {
    private NewBMotionProjectWizardPage page;
    private IStructuredSelection selection;

    public NewBMotionProjectWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new NewBMotionProjectWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public void init(IWorkbench workbench, IStructuredSelection sel) {
        this.selection = sel;
    }

    public boolean performFinish() {
        final String projectName = this.page.getFileName();
        final String projectRoot = this.page.getProjectRoot();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewBMotionProjectWizard.this.doFinish(projectRoot, projectName, NewBMotionProjectWizard.this.page.getProject(), NewBMotionProjectWizard.this.page.getInitialContents("bmso"), monitor);
                    }
                    catch (CoreException e) {
                        Logger.getAnonymousLogger().log(Level.SEVERE, "CoreException", e);
                        monitor.done();
                    }
                    catch (UnsupportedEncodingException e) {
                        Logger.getAnonymousLogger().log(Level.SEVERE, "CoreException", e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String projectRoot, final String projectName, final IProject project, final InputStream defaultContentStudio, final IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + projectName + " BMotion Studio Visualization", 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(projectRoot));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            throw new CoreException((IStatus)new Status(4, "org.eventb.internal.ui", 0, "Project \"" + projectRoot + "\" does not exist.", null));
        }
        RodinCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

            public void run(IProgressMonitor pMonitor) throws CoreException {
                IFile file = project.getFile(projectName + ".bmso");
                file.create(defaultContentStudio, false, monitor);
                file.refreshLocal(0, null);
            }
        }, (IProgressMonitor)monitor);
        monitor.worked(1);
    }
}

