/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.eventb;

import de.bmotionstudio.gef.editor.eventb.MachineContentObject;
import de.bmotionstudio.gef.editor.eventb.MachineOperation;
import de.bmotionstudio.gef.editor.model.Visualization;
import de.prob.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eventb.core.ISCConstant;
import org.eventb.core.ISCContextRoot;
import org.eventb.core.ISCEvent;
import org.eventb.core.ISCInternalContext;
import org.eventb.core.ISCInvariant;
import org.eventb.core.ISCMachineRoot;
import org.eventb.core.ISCParameter;
import org.eventb.core.ISCVariable;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.basis.ContextRoot;
import org.eventb.core.basis.EventBRoot;
import org.eventb.core.basis.MachineRoot;
import org.rodinp.core.IRodinFile;
import org.rodinp.core.IRodinProject;
import org.rodinp.core.RodinCore;
import org.rodinp.core.RodinDBException;

public final class EventBHelper {
    private static FormulaFactory formularFactory = FormulaFactory.getDefault();

    public static EventBRoot getCorrespondingFile(IFile file, String machineFileName) {
        IRodinFile rFile;
        IRodinProject rProject = RodinCore.valueOf((IProject)file.getProject());
        EventBRoot root = null;
        if (rProject != null && (rFile = rProject.getRodinFile(machineFileName)) != null && rFile.getRoot() instanceof EventBRoot) {
            root = (EventBRoot)rFile.getRoot();
        }
        return root;
    }

    public static List<MachineOperation> getOperations(Visualization visualization) {
        ArrayList<MachineOperation> tmpSet = new ArrayList<MachineOperation>();
        if (visualization.getLanguage().equals("EventB")) {
            EventBRoot correspondingFile = EventBHelper.getCorrespondingFile(visualization.getProjectFile(), visualization.getMachineName());
            if (correspondingFile instanceof MachineRoot && correspondingFile.exists()) {
                ISCMachineRoot machineRoot = correspondingFile.getSCMachineRoot();
                try {
                    ISCEvent[] events;
                    ISCEvent[] iSCEventArray = events = machineRoot.getSCEvents();
                    int n = events.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ISCEvent event = iSCEventArray[n2];
                        ArrayList<String> parSet = new ArrayList<String>();
                        ArrayList<String> guardSet = new ArrayList<String>();
                        ISCParameter[] iSCParameterArray = event.getSCParameters();
                        int n3 = iSCParameterArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ISCParameter par = iSCParameterArray[n4];
                            parSet.add(par.getIdentifierString());
                            ++n4;
                        }
                        iSCParameterArray = event.getSCGuards();
                        n3 = iSCParameterArray.length;
                        n4 = 0;
                        while (n4 < n3) {
                            ISCParameter guard = iSCParameterArray[n4];
                            guardSet.add(guard.getPredicateString());
                            ++n4;
                        }
                        MachineOperation op = new MachineOperation(event.getLabel(), parSet, guardSet, EventBHelper.renderEvent(event));
                        tmpSet.add(op);
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    String message = "Rodin DB Exception while getting operations: " + e.getLocalizedMessage();
                    Logger.notifyUser((String)message, (Throwable)e);
                    return Collections.unmodifiableList(new ArrayList());
                }
            } else {
                visualization.getLanguage().equals("ClassicalB");
            }
        }
        return tmpSet;
    }

    public static List<MachineContentObject> getVariables(Visualization visualization) {
        EventBRoot correspondingFile = EventBHelper.getCorrespondingFile(visualization.getProjectFile(), visualization.getMachineName());
        ArrayList<MachineContentObject> tmpSet = new ArrayList<MachineContentObject>();
        if (correspondingFile instanceof MachineRoot && correspondingFile.exists()) {
            ISCMachineRoot machineRoot = correspondingFile.getSCMachineRoot();
            try {
                ISCVariable[] vars;
                ISCVariable[] iSCVariableArray = vars = machineRoot.getSCVariables();
                int n = vars.length;
                int n2 = 0;
                while (n2 < n) {
                    ISCVariable var = iSCVariableArray[n2];
                    MachineContentObject machinevar = new MachineContentObject(var.getIdentifierString());
                    machinevar.setType(var.getType(formularFactory));
                    tmpSet.add(machinevar);
                    ++n2;
                }
            }
            catch (CoreException e) {
                String message = "Rodin DB Exception while getting variables: " + e.getLocalizedMessage();
                Logger.notifyUser((String)message, (Throwable)e);
                return Collections.unmodifiableList(new ArrayList());
            }
        }
        return tmpSet;
    }

    public static List<MachineContentObject> getInvariants(Visualization visualization) {
        EventBRoot correspondingFile = EventBHelper.getCorrespondingFile(visualization.getProjectFile(), visualization.getMachineName());
        ArrayList<MachineContentObject> tmpSet = new ArrayList<MachineContentObject>();
        if (correspondingFile instanceof MachineRoot && correspondingFile.exists()) {
            ISCMachineRoot machineRoot = correspondingFile.getSCMachineRoot();
            try {
                ISCInvariant[] invariants;
                ISCInvariant[] iSCInvariantArray = invariants = machineRoot.getSCInvariants();
                int n = invariants.length;
                int n2 = 0;
                while (n2 < n) {
                    ISCInvariant inv = iSCInvariantArray[n2];
                    MachineContentObject machineinv = new MachineContentObject(inv.getPredicateString());
                    tmpSet.add(machineinv);
                    ++n2;
                }
            }
            catch (RodinDBException e) {
                String message = "Rodin DB Exception while getting invariants: " + e.getLocalizedMessage();
                Logger.notifyUser((String)message, (Throwable)e);
                return Collections.unmodifiableList(new ArrayList());
            }
        }
        return tmpSet;
    }

    public static List<MachineContentObject> getConstants(Visualization visualization) {
        ArrayList<MachineContentObject> tmpSet;
        block11: {
            EventBRoot correspondingFile = EventBHelper.getCorrespondingFile(visualization.getProjectFile(), visualization.getMachineName());
            tmpSet = new ArrayList<MachineContentObject>();
            if (correspondingFile.exists()) {
                try {
                    if (correspondingFile instanceof MachineRoot) {
                        ISCInternalContext[] seenContexts;
                        ISCMachineRoot machineRoot = correspondingFile.getSCMachineRoot();
                        ISCInternalContext[] iSCInternalContextArray = seenContexts = machineRoot.getSCSeenContexts();
                        int n = seenContexts.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ISCInternalContext context = iSCInternalContextArray[n2];
                            ISCConstant[] iSCConstantArray = context.getSCConstants();
                            int n3 = iSCConstantArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                ISCConstant constant = iSCConstantArray[n4];
                                try {
                                    MachineContentObject machineinv = new MachineContentObject(constant.getIdentifierString());
                                    machineinv.setType(constant.getType(formularFactory));
                                    tmpSet.add(machineinv);
                                }
                                catch (CoreException e) {
                                    String message = "Rodin DB Exception while getting variables: " + e.getLocalizedMessage();
                                    Logger.notifyUser((String)message, (Throwable)e);
                                    return Collections.unmodifiableList(new ArrayList());
                                }
                                ++n4;
                            }
                            ++n2;
                        }
                        break block11;
                    }
                    if (!(correspondingFile instanceof ContextRoot)) break block11;
                    ISCContextRoot contextRoot = correspondingFile.getSCContextRoot();
                    ISCConstant[] iSCConstantArray = contextRoot.getSCConstants();
                    int n = iSCConstantArray.length;
                    int n5 = 0;
                    while (n5 < n) {
                        ISCConstant constant = iSCConstantArray[n5];
                        MachineContentObject machineinv = new MachineContentObject(constant.getIdentifierString());
                        try {
                            machineinv.setType(constant.getType(formularFactory));
                        }
                        catch (CoreException e) {
                            String message = "Rodin DB Exception while getting variables: " + e.getLocalizedMessage();
                            Logger.notifyUser((String)message, (Throwable)e);
                            return Collections.unmodifiableList(new ArrayList());
                        }
                        tmpSet.add(machineinv);
                        ++n5;
                    }
                }
                catch (RodinDBException e) {
                    String message = "Rodin DB Exception while getting constants: " + e.getLocalizedMessage();
                    Logger.notifyUser((String)message, (Throwable)e);
                    return Collections.unmodifiableList(new ArrayList());
                }
            }
        }
        return tmpSet;
    }

    public static String renderEvent(ISCEvent event) throws CoreException {
        int n;
        int n2;
        ISCParameter[] iSCParameterArray;
        StringBuffer sb = new StringBuffer();
        sb.append("event ");
        sb.append(event.getLabel());
        sb.append("\n");
        if (event.getSCParameters().length > 0) {
            sb.append("  any ");
            iSCParameterArray = event.getSCParameters();
            n2 = iSCParameterArray.length;
            n = 0;
            while (n < n2) {
                ISCParameter parameter = iSCParameterArray[n];
                sb.append(parameter.getIdentifierString());
                sb.append(" ");
                ++n;
            }
            sb.append("\n");
        }
        if (event.getSCGuards().length > 0) {
            sb.append("  where\n");
            iSCParameterArray = event.getSCGuards();
            n2 = iSCParameterArray.length;
            n = 0;
            while (n < n2) {
                ISCParameter guard = iSCParameterArray[n];
                sb.append("    @");
                sb.append(guard.getLabel());
                sb.append(" ");
                sb.append(guard.getPredicateString());
                sb.append("\n");
                ++n;
            }
        }
        if (event.getSCActions().length > 0) {
            sb.append("  then\n");
            iSCParameterArray = event.getSCActions();
            n2 = iSCParameterArray.length;
            n = 0;
            while (n < n2) {
                ISCParameter action = iSCParameterArray[n];
                sb.append("    @");
                sb.append(action.getLabel());
                sb.append(" ");
                sb.append(action.getAssignmentString());
                sb.append("\n");
                ++n;
            }
        }
        sb.append("end");
        return sb.toString();
    }
}

