/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.editpolicy;

import de.bmotionstudio.gef.editor.command.AddCommand;
import de.bmotionstudio.gef.editor.command.BControlChangeLayoutCommand;
import de.bmotionstudio.gef.editor.command.ReorderPartCommand;
import de.bmotionstudio.gef.editor.editpolicy.BMSResizableEditPolicy;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.model.Light;
import de.bmotionstudio.gef.editor.model.Signal;
import java.util.List;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class SignalLayoutEditPolicy
extends FlowLayoutEditPolicy {
    private static final Dimension PREFERRED_SIZE = new Dimension(-1, -1);
    protected static final Dimension UNSPECIFIED_SIZE = new Dimension();

    protected Command createAddCommand(EditPart child, EditPart after) {
        BControl childModel = (BControl)child.getModel();
        BControl parentModel = (BControl)this.getHost().getModel();
        if (childModel instanceof Light && parentModel instanceof Signal) {
            AddCommand command = new AddCommand();
            command.setChild(childModel);
            command.setParent(parentModel);
            int index = this.getHost().getChildren().indexOf(after);
            command.setIndex(index);
            return command;
        }
        return null;
    }

    public Command getCommand(Request request) {
        if ("resize children".equals(request.getType())) {
            return this.getResizeChildrenCommand((ChangeBoundsRequest)request);
        }
        return super.getCommand(request);
    }

    protected Command getResizeChildrenCommand(ChangeBoundsRequest request) {
        CompoundCommand resize = new CompoundCommand();
        List children = request.getEditParts();
        int i = 0;
        while (i < children.size()) {
            GraphicalEditPart child = (GraphicalEditPart)children.get(i);
            Command c = this.createChangeConstraintCommand(request, (EditPart)child, this.translateToModelConstraint(this.getConstraintFor(request, child)));
            resize.add(c);
            ++i;
        }
        return resize.unwrap();
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        BControlChangeLayoutCommand cmd = new BControlChangeLayoutCommand();
        cmd.setModel(child.getModel());
        cmd.setConstraint((Rectangle)constraint);
        return cmd;
    }

    protected Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        PrecisionRectangle locationAndSize = new PrecisionRectangle(child.getFigure().getBounds());
        child.getFigure().translateToAbsolute((Translatable)locationAndSize);
        locationAndSize = request.getTransformedRectangle((Rectangle)locationAndSize);
        this.translateFromAbsoluteToLayoutRelative((Translatable)locationAndSize);
        return this.getConstraintFor((Request)request, child, (Rectangle)locationAndSize);
    }

    protected Object getConstraintFor(Request request, GraphicalEditPart child, Rectangle rectangle) {
        if (UNSPECIFIED_SIZE.equals((Object)rectangle.getSize())) {
            return this.getConstraintFor(rectangle.getLocation());
        }
        return this.getConstraintFor(rectangle);
    }

    protected Object getConstraintFor(CreateRequest request) {
        PrecisionRectangle locationAndSize = null;
        locationAndSize = request.getSize() == null || request.getSize().isEmpty() ? new PrecisionRectangle(request.getLocation(), UNSPECIFIED_SIZE) : new PrecisionRectangle(request.getLocation(), request.getSize());
        this.translateFromAbsoluteToLayoutRelative((Translatable)locationAndSize);
        return this.getConstraintFor((Request)request, null, (Rectangle)locationAndSize);
    }

    protected Object getConstraintFor(Point p) {
        return new Rectangle(p, PREFERRED_SIZE);
    }

    protected Object getConstraintFor(Rectangle r) {
        return new Rectangle(r);
    }

    protected Object translateToModelConstraint(Object figureConstraint) {
        return figureConstraint;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        BMSResizableEditPolicy policy = new BMSResizableEditPolicy();
        policy.setResizeDirections(24);
        return policy;
    }

    protected Command createMoveChildCommand(EditPart child, EditPart after) {
        BControl childModel = (BControl)child.getModel();
        BControl parentModel = (BControl)this.getHost().getModel();
        if (childModel instanceof Light && parentModel instanceof Signal) {
            int oldIndex = this.getHost().getChildren().indexOf(child);
            int newIndex = this.getHost().getChildren().indexOf(after);
            if (newIndex > oldIndex) {
                --newIndex;
            }
            ReorderPartCommand command = new ReorderPartCommand(childModel, parentModel, newIndex);
            return command;
        }
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        return null;
    }

    protected boolean isHorizontal() {
        IFigure figure = this.getLayoutContainer();
        if (figure.getLayoutManager() instanceof ToolbarLayout) {
            return ((ToolbarLayout)figure.getLayoutManager()).isHorizontal();
        }
        if (figure.getLayoutManager() instanceof FlowLayout) {
            return ((FlowLayout)figure.getLayoutManager()).isHorizontal();
        }
        return false;
    }
}

