/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.editpolicy;

import de.bmotionstudio.gef.editor.attribute.BAttributeHeight;
import de.bmotionstudio.gef.editor.attribute.BAttributeWidth;
import de.bmotionstudio.gef.editor.command.BControlChangeLayoutCommand;
import de.bmotionstudio.gef.editor.command.ChangeGuideCommand;
import de.bmotionstudio.gef.editor.command.CreateCommand;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.model.BMotionGuide;
import de.bmotionstudio.gef.editor.part.BMSAbstractEditPart;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.rulers.RulerProvider;

public class BMSEditLayoutPolicy
extends XYLayoutEditPolicy {
    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        return null;
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        int edgeBeingResized;
        int alignment;
        Integer guidePos;
        BControlChangeLayoutCommand cmd = new BControlChangeLayoutCommand();
        BControl part = (BControl)child.getModel();
        cmd.setModel(child.getModel());
        cmd.setConstraint((Rectangle)constraint);
        BControlChangeLayoutCommand result = cmd;
        if ((request.getResizeDirection() & 5) != 0) {
            guidePos = (Integer)request.getExtendedData().get("SnapToGuides.HorizontalGuide");
            if (guidePos != null) {
                result = this.chainGuideAttachmentCommand((Request)request, part, result, true);
            } else if (part.getHorizontalGuide() != null) {
                alignment = part.getHorizontalGuide().getAlignment(part);
                edgeBeingResized = 0;
                edgeBeingResized = (request.getResizeDirection() & 1) != 0 ? -1 : 1;
                if (alignment == edgeBeingResized) {
                    result = result.chain(new ChangeGuideCommand(part, true));
                }
            }
        }
        if ((request.getResizeDirection() & 0x18) != 0) {
            guidePos = (Integer)request.getExtendedData().get("SnapToGuides.VerticalGuide");
            if (guidePos != null) {
                result = this.chainGuideAttachmentCommand((Request)request, part, result, false);
            } else if (part.getVerticalGuide() != null) {
                alignment = part.getVerticalGuide().getAlignment(part);
                edgeBeingResized = 0;
                edgeBeingResized = (request.getResizeDirection() & 8) != 0 ? -1 : 1;
                if (alignment == edgeBeingResized) {
                    result = result.chain(new ChangeGuideCommand(part, false));
                }
            }
        }
        if (request.getType().equals("move children") || request.getType().equals("align children")) {
            result = this.chainGuideAttachmentCommand((Request)request, part, result, true);
            result = this.chainGuideAttachmentCommand((Request)request, part, result, false);
            result = this.chainGuideDetachmentCommand((Request)request, part, result, true);
            result = this.chainGuideDetachmentCommand((Request)request, part, result, false);
        }
        return result;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        BControl control = (BControl)child.getModel();
        ResizableEditPolicy policy = new ResizableEditPolicy();
        BAttributeWidth atrWidth = (BAttributeWidth)control.getAttributes().get("de.bmotionstudio.gef.editor.attribute.BAttributeWidth");
        BAttributeHeight atrHeight = (BAttributeHeight)control.getAttributes().get("de.bmotionstudio.gef.editor.attribute.BAttributeHeight");
        if (atrWidth.isEditable() && atrHeight.isEditable()) {
            return policy;
        }
        if (atrWidth.isEditable()) {
            policy.setResizeDirections(24);
            return policy;
        }
        if (atrHeight.isEditable()) {
            policy.setResizeDirections(5);
            return policy;
        }
        policy.setResizeDirections(0);
        return policy;
    }

    protected Command getCreateCommand(CreateRequest request) {
        if (request.getType() == "create child" && this.getHost() instanceof BMSAbstractEditPart && ((BControl)((BMSAbstractEditPart)this.getHost()).getModel()).canHaveChildren()) {
            BControl newObj = (BControl)request.getNewObject();
            CreateCommand createCmd = new CreateCommand(newObj, (BControl)this.getHost().getModel());
            Rectangle constraint = (Rectangle)this.getConstraintFor(request);
            constraint.x = constraint.x < 0 ? 0 : constraint.x;
            constraint.y = constraint.y < 0 ? 0 : constraint.y;
            BAttributeWidth atrWidth = (BAttributeWidth)newObj.getAttributes().get("de.bmotionstudio.gef.editor.attribute.BAttributeWidth");
            BAttributeHeight atrHeight = (BAttributeHeight)newObj.getAttributes().get("de.bmotionstudio.gef.editor.attribute.BAttributeHeight");
            Integer cWidth = Integer.valueOf(atrWidth.getDefaultValue().toString());
            constraint.width = !atrWidth.isEditable() ? cWidth : (constraint.width <= 0 ? cWidth : constraint.width);
            Integer cHeight = Integer.valueOf(atrHeight.getDefaultValue().toString());
            constraint.height = !atrHeight.isEditable() ? cHeight : (constraint.height <= 0 ? cHeight : constraint.height);
            createCmd.setLayout(constraint);
            Command cmd = this.chainGuideAttachmentCommand((Request)request, newObj, createCmd, true);
            return this.chainGuideAttachmentCommand((Request)request, newObj, cmd, false);
        }
        return null;
    }

    protected Command chainGuideAttachmentCommand(Request request, BControl part, Command cmd, boolean horizontal) {
        Command result = cmd;
        Integer guidePos = (Integer)request.getExtendedData().get(horizontal ? "SnapToGuides.HorizontalGuide" : "SnapToGuides.VerticalGuide");
        if (guidePos != null) {
            int alignment = (Integer)request.getExtendedData().get(horizontal ? "SnapToGuides.HorizontalAttachment" : "SnapToGuides.VerticalAttachment");
            ChangeGuideCommand cgm = new ChangeGuideCommand(part, horizontal);
            cgm.setNewGuide(this.findGuideAt(guidePos, horizontal), alignment);
            result = result.chain((Command)cgm);
        }
        return result;
    }

    protected Command chainGuideDetachmentCommand(Request request, BControl part, Command cmd, boolean horizontal) {
        Command result = cmd;
        Integer guidePos = (Integer)request.getExtendedData().get(horizontal ? "SnapToGuides.HorizontalGuide" : "SnapToGuides.VerticalGuide");
        if (guidePos == null) {
            result = result.chain((Command)new ChangeGuideCommand(part, horizontal));
        }
        return result;
    }

    protected BMotionGuide findGuideAt(int pos, boolean horizontal) {
        RulerProvider provider = (RulerProvider)this.getHost().getViewer().getProperty(horizontal ? "vertical ruler" : "horizontal ruler");
        return (BMotionGuide)provider.getGuideAt(pos);
    }
}

