/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.edit;

import de.bmotionstudio.gef.editor.BMotionStudioSWTConstants;
import de.bmotionstudio.gef.editor.edit.IPopupListener;
import de.bmotionstudio.gef.editor.edit.PopupResult;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextEditorWindow
extends Window {
    private String value;
    private Point position;
    private Text text;
    private PopupResult result = new PopupResult();
    private List<IPopupListener> popupListener = new ArrayList<IPopupListener>();

    protected TextEditorWindow(Shell parentShell, Text text) {
        this((IShellProvider)new SameShellProvider((Control)parentShell), text);
    }

    protected TextEditorWindow(IShellProvider parentShell, Text text) {
        super(parentShell);
        this.value = text.getText();
        this.position = text.toDisplay(0, 0);
        this.result.setReturncode(this.getReturnCode());
        this.setShellStyle(16384);
        this.setBlockOnOpen(true);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.text = new Text(composite, 66);
        this.text.setText(this.value);
        this.text.selectAll();
        this.text.setFont(BMotionStudioSWTConstants.fontArial10);
        return composite;
    }

    protected Point getInitialSize() {
        return new Point(500, 200);
    }

    protected Point getInitialLocation(Point initialSize) {
        return this.position;
    }

    protected void configureShell(Shell newShell) {
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                TextEditorWindow.this.setReturnCode(0);
                TextEditorWindow.this.close();
            }
        });
        super.configureShell(newShell);
    }

    protected void setReturnCode(int code) {
        this.result.setReturncode(code);
        super.setReturnCode(code);
    }

    public boolean close() {
        this.result.setValue(this.text.getText());
        this.notifyPopupClosed();
        boolean b = super.close();
        return b;
    }

    public PopupResult openPopup() {
        this.notifyPopupOpened();
        int i = super.open();
        this.result.setReturncode(i);
        return this.result;
    }

    public void notifyPopupOpened() {
        for (IPopupListener l : this.popupListener) {
            l.popupOpened();
        }
    }

    public void notifyPopupClosed() {
        for (IPopupListener l : this.popupListener) {
            l.popupClosed();
        }
    }

    public void addPopupListener(IPopupListener l) {
        this.popupListener.add(l);
    }

    public void removePopupListener(IPopupListener l) {
        this.popupListener.remove(l);
    }
}

