/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.attribute;

import de.bmotionstudio.gef.editor.model.BControl;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public abstract class AbstractAttribute
implements IPropertySource,
Cloneable {
    public static final String ROOT = "de.bmotionstudio.gef.editor.attribute.BAttributeRoot";
    private transient HashMap<String, AbstractAttribute> children;
    private transient BControl control;
    private transient PropertyDescriptor propertyDescriptor;
    private transient Object initValue;
    private transient Object defaultValue;
    private transient boolean editable;
    private transient boolean show;
    private transient String group;
    private Object value;

    public AbstractAttribute(Object value) {
        this.value = value;
        this.defaultValue = value;
        this.group = "de.bmotionstudio.gef.editor.attribute.BAttributeMisc";
        this.editable = true;
        this.show = true;
    }

    private Object readResolve() {
        this.initValue = this.value;
        return this;
    }

    public void addChild(AbstractAttribute atr) {
        this.getChildren().put(atr.getID(), atr);
    }

    public Boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    public PropertyDescriptor getPropertyDescriptor() {
        this.propertyDescriptor = new PropertyDescriptor((Object)this.getID(), this.getName());
        if (this.isEditable()) {
            this.propertyDescriptor = this.preparePropertyDescriptor();
            if (this.propertyDescriptor != null) {
                this.propertyDescriptor.setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        return AbstractAttribute.this.validateValue(value, AbstractAttribute.this.control);
                    }
                });
            }
        }
        return this.propertyDescriptor;
    }

    protected abstract PropertyDescriptor preparePropertyDescriptor();

    public Object unmarshal(String s) {
        return s;
    }

    public String getID() {
        return this.getClass().getName();
    }

    public abstract String getName();

    public void setGroup(AbstractAttribute group) {
        this.setGroup(group.getClass().getName());
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptor = new ArrayList<PropertyDescriptor>();
        for (AbstractAttribute atr : this.getChildren().values()) {
            descriptor.add(atr.getPropertyDescriptor());
        }
        return descriptor.toArray(new IPropertyDescriptor[0]);
    }

    public Object getPropertyValue(Object attrID) {
        AbstractAttribute atr = this.getChildren().get(attrID);
        if (atr.hasChildren().booleanValue()) {
            return atr;
        }
        return atr.getValue();
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        AbstractAttribute atr = this.children.get(id);
        atr.setValue(value);
    }

    public void setValue(Object value) {
        this.setValue(value, true, true);
    }

    public void setValue(Object value, Boolean firePropertyChange, Boolean setInitVal) {
        Object oldVal = this.value;
        this.value = value;
        if (setInitVal.booleanValue()) {
            this.initValue = value;
        }
        if (firePropertyChange.booleanValue() && this.control != null) {
            this.control.getListeners().firePropertyChange(this.getID(), oldVal, value);
        }
    }

    public void restoreValue() {
        Object oldVal = this.value;
        this.value = this.initValue;
        if (this.control != null) {
            this.control.getListeners().firePropertyChange(this.getID(), oldVal, this.value);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public Object getInitValue() {
        return this.initValue;
    }

    public HashMap<String, AbstractAttribute> getChildren() {
        if (this.children == null) {
            this.children = new HashMap();
        }
        return this.children;
    }

    public AbstractAttribute clone() throws CloneNotSupportedException {
        return (AbstractAttribute)super.clone();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public String validateValue(Object value, BControl control) {
        return null;
    }

    public void setShow(boolean show) {
        this.show = show;
    }

    public boolean show() {
        return this.show;
    }

    public BControl getControl() {
        return this.control;
    }

    public void setControl(BControl control) {
        this.control = control;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }
}

