/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.action;

import de.bmotionstudio.gef.editor.BMotionEditorPlugin;
import de.bmotionstudio.gef.editor.BMotionStudioImage;
import de.bmotionstudio.gef.editor.action.BMotionSchedulerEventWizardDialog;
import de.bmotionstudio.gef.editor.action.RemoveSchedulerEventAction;
import de.bmotionstudio.gef.editor.command.SchedulerEventCommand;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.scheduler.SchedulerEvent;
import de.bmotionstudio.gef.editor.scheduler.SchedulerWizard;
import de.prob.logging.Logger;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IWorkbenchPart;

public class OpenSchedulerEventAction
extends SelectionAction {
    private String className;
    private String eventID;
    private SchedulerEvent clonedSchedulerEvent;

    public OpenSchedulerEventAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(true);
    }

    protected void init() {
        this.setEnabled(false);
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public void run() {
        BControl bcontrol = this.getControl();
        this.clonedSchedulerEvent = null;
        if (bcontrol != null) {
            SchedulerEvent newSchedulerEvent = bcontrol.getEvent(this.getEventID());
            if (newSchedulerEvent == null) {
                try {
                    newSchedulerEvent = (SchedulerEvent)BMotionEditorPlugin.getSchedulerExtension(this.getClassName()).createExecutableExtension("class");
                }
                catch (CoreException coreException) {}
            } else {
                try {
                    this.clonedSchedulerEvent = newSchedulerEvent.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
            }
            if (newSchedulerEvent != null) {
                newSchedulerEvent.setEventID(this.getEventID());
                SchedulerWizard wizard = newSchedulerEvent.getWizard(bcontrol);
                if (wizard != null) {
                    BMotionSchedulerEventWizardDialog dialog = new BMotionSchedulerEventWizardDialog(this.getWorkbenchPart(), (IWizard)wizard);
                    dialog.create();
                    dialog.getShell().setSize(wizard.getSize());
                    String title = "Scheduler Event: " + newSchedulerEvent.getName() + " Control: " + String.valueOf(bcontrol.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeID"));
                    wizard.setWindowTitle("BMotion Studio Scheduler Event Wizard");
                    dialog.setTitle(title);
                    dialog.setMessage(newSchedulerEvent.getDescription());
                    dialog.setTitleImage(BMotionStudioImage.getImage("logo_bmotion64"));
                    int status = dialog.open();
                    if (status == 0) {
                        SchedulerEventCommand schedulerEventCommand = this.createSchedulerEventCommand();
                        schedulerEventCommand.setNewSchedulerEvent(newSchedulerEvent);
                        if (wizard.isEventDelete().booleanValue()) {
                            RemoveSchedulerEventAction action = new RemoveSchedulerEventAction(this.getWorkbenchPart());
                            action.setControl(this.getControl());
                            action.setSchedulerEvent(this.clonedSchedulerEvent);
                            action.run();
                        } else {
                            if (this.clonedSchedulerEvent != null) {
                                schedulerEventCommand.setClonedSchedulerEvent(this.clonedSchedulerEvent);
                            }
                            this.execute(schedulerEventCommand);
                        }
                    } else if (status == 1 && this.clonedSchedulerEvent != null) {
                        bcontrol.addEvent(this.getEventID(), this.clonedSchedulerEvent);
                    }
                } else {
                    Logger.notifyUser((String)("The Scheduler Event \"" + newSchedulerEvent.getName() + "\" does not support a wizard."));
                }
            }
        }
    }

    public SchedulerEventCommand createSchedulerEventCommand() {
        SchedulerEventCommand command = new SchedulerEventCommand();
        command.setClassName(this.getClassName());
        command.setEventID(this.getEventID());
        command.setControl(this.getControl());
        return command;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setEventID(String eventID) {
        this.eventID = eventID;
    }

    public String getEventID() {
        return this.eventID;
    }

    protected BControl getControl() {
        List objects = this.getSelectedObjects();
        if (objects.isEmpty()) {
            return null;
        }
        if (!(objects.get(0) instanceof EditPart)) {
            return null;
        }
        EditPart part = (EditPart)objects.get(0);
        return (BControl)part.getModel();
    }
}

