/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.action;

import de.bmotionstudio.gef.editor.command.FitImageCommand;
import de.bmotionstudio.gef.editor.model.BControl;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class FitImageAction
extends SelectionAction {
    public static final String ID = "de.bmotionstudio.gef.editor.action.fitImage";

    public FitImageAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(false);
    }

    protected void init() {
        this.setText("Fit size to image");
        this.setToolTipText("Fit size to image");
        this.setId(ID);
        ImageDescriptor icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"de.bmotionstudio.gef.editor", (String)"icons/icon_fitimage.png");
        if (icon != null) {
            this.setImageDescriptor(icon);
        }
        this.setEnabled(false);
    }

    protected boolean calculateEnabled() {
        List selectedObjects = this.getSelectedObjects();
        for (Object obj : selectedObjects) {
            BControl bcontrol;
            EditPart part;
            if (!(obj instanceof EditPart) || !((part = (EditPart)obj).getModel() instanceof BControl) || (bcontrol = (BControl)part.getModel()).getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeImage") == null) continue;
            return true;
        }
        return false;
    }

    public FitImageCommand createFitImageCommand(List<BControl> modelList, Map<BControl, org.eclipse.draw2d.geometry.Rectangle> newSizeMap) {
        FitImageCommand command = new FitImageCommand();
        command.setModelList(modelList);
        command.setNewSizeMap(newSizeMap);
        return command;
    }

    public void run() {
        ArrayList<BControl> modelList = new ArrayList<BControl>();
        HashMap<BControl, org.eclipse.draw2d.geometry.Rectangle> newSizeMap = new HashMap<BControl, org.eclipse.draw2d.geometry.Rectangle>();
        List selectedObjects = this.getSelectedObjects();
        for (Object obj : selectedObjects) {
            String myPath;
            EditPart part;
            BControl control;
            Object imgAttribute;
            if (!(obj instanceof EditPart) || (imgAttribute = (control = (BControl)(part = (EditPart)obj).getModel()).getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeImage")) == null) continue;
            String imagePath = control.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeImage").toString();
            Rectangle imageBounds = null;
            Image img = null;
            IFile pFile = control.getVisualization().getProjectFile();
            if (pFile != null && new File(myPath = (String.valueOf(pFile.getProject().getLocation()) + "/images/" + imagePath).replace("file:", "")).exists() && imagePath.length() > 0) {
                img = new Image((Device)Display.getCurrent(), myPath);
                imageBounds = img.getBounds();
            }
            if (imageBounds != null) {
                modelList.add(control);
                newSizeMap.put(control, new org.eclipse.draw2d.geometry.Rectangle(Integer.valueOf(control.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeX").toString()).intValue(), Integer.valueOf(control.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeY").toString()).intValue(), imageBounds.width, imageBounds.height));
            }
            if (img == null) continue;
            img.dispose();
        }
        this.execute(this.createFitImageCommand(modelList, newSizeMap));
    }
}

