/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.action;

import de.bmotionstudio.gef.editor.command.CopyCommand;
import de.bmotionstudio.gef.editor.model.BControl;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class CopyAction
extends SelectionAction {
    public CopyAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(true);
    }

    protected void init() {
        super.init();
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setText("Copy");
        this.setId(ActionFactory.COPY.getId());
        this.setHoverImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setEnabled(false);
    }

    private Command createCopyCommand(List<Object> selectedObjects) {
        if (selectedObjects == null || selectedObjects.isEmpty()) {
            return null;
        }
        CopyCommand cmd = new CopyCommand();
        for (Object nextElement : selectedObjects) {
            BControl node;
            EditPart ep;
            if (!(nextElement instanceof EditPart) || !((ep = (EditPart)nextElement).getModel() instanceof BControl) || !cmd.isCopyableControl(node = (BControl)ep.getModel())) continue;
            cmd.addElement(node);
        }
        return cmd;
    }

    protected boolean calculateEnabled() {
        Command cmd = this.createCopyCommand(this.getSelectedObjects());
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    public void run() {
        Command cmd = this.createCopyCommand(this.getSelectedObjects());
        if (cmd != null && cmd.canExecute()) {
            cmd.execute();
        }
    }
}

