/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor;

import de.bmotionstudio.gef.editor.BMotionStudioImage;
import de.bmotionstudio.gef.editor.IInstallMenu;
import de.bmotionstudio.gef.editor.action.OpenSchedulerEventAction;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.model.Visualization;
import de.bmotionstudio.gef.editor.scheduler.SchedulerEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.ActionFactory;

public class BMSContextMenuProvider
extends ContextMenuProvider {
    private ActionRegistry actionRegistry;
    private IExtensionRegistry registry = Platform.getExtensionRegistry();
    private String[] eventIDs = new String[]{"de.bmotionstudio.gef.editor.event.OnClickEvent"};

    public BMSContextMenuProvider(EditPartViewer viewer, ActionRegistry registry) {
        super(viewer);
        this.setActionRegistry(registry);
    }

    public void buildContextMenu(IMenuManager menu) {
        GEFActionConstants.addStandardActionGroups((IMenuManager)menu);
        IAction action = this.getActionRegistry().getAction((Object)ActionFactory.UNDO.getId());
        menu.appendToGroup("org.eclipse.gef.group.undo", action);
        action = this.getActionRegistry().getAction((Object)ActionFactory.REDO.getId());
        menu.appendToGroup("org.eclipse.gef.group.undo", action);
        action = this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId());
        menu.appendToGroup("org.eclipse.gef.group.copy", action);
        action = this.getActionRegistry().getAction((Object)ActionFactory.PASTE.getId());
        menu.appendToGroup("org.eclipse.gef.group.copy", action);
        action = this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId());
        menu.appendToGroup("org.eclipse.gef.group.edit", action);
        Object sel = ((IStructuredSelection)this.getViewer().getSelection()).getFirstElement();
        if (sel instanceof AbstractEditPart) {
            AbstractEditPart editPart = (AbstractEditPart)sel;
            this.buildCustomMenu(menu, editPart);
            this.buildObserverMenu(menu, editPart);
            this.buildEventMenu(menu, editPart);
        }
    }

    private void buildCustomMenu(IMenuManager menu, AbstractEditPart editPart) {
        Object model = editPart.getModel();
        if (model instanceof BControl) {
            IExtensionPoint extensionPoint = this.registry.getExtensionPoint("de.bmotionstudio.gef.editor.installMenu");
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    if ("menu".equals(configurationElement.getName())) {
                        try {
                            IInstallMenu installMenuClass = (IInstallMenu)configurationElement.createExecutableExtension("class");
                            installMenuClass.installMenu(menu, this.getActionRegistry());
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private void buildObserverMenu(IMenuManager menu, AbstractEditPart editPart) {
        Object model = editPart.getModel();
        BControl bcontrol = null;
        if (!(model instanceof BControl)) {
            return;
        }
        bcontrol = (BControl)model;
        MenuManager handleObserverMenu = new MenuManager("Observer", BMotionStudioImage.getImageDescriptor("de.bmotionstudio.gef.editor", "icons/icon_observer.gif"), "observerMenu");
        menu.appendToGroup("group.add", (IContributionItem)handleObserverMenu);
        IExtensionPoint extensionPoint = this.registry.getExtensionPoint("de.bmotionstudio.gef.editor.observer");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if ("observer".equals(configurationElement.getName())) {
                    String observerClassName = configurationElement.getAttribute("class");
                    String observerName = configurationElement.getAttribute("name");
                    if (this.checkIncludeObserver(observerClassName, bcontrol)) {
                        IAction action = this.getActionRegistry().getAction((Object)("de.bmotionstudio.gef.editor.observerAction." + observerClassName));
                        action.setText(observerName);
                        action.setToolTipText(observerName);
                        if (bcontrol.hasObserver(observerClassName).booleanValue()) {
                            action.setImageDescriptor(BMotionStudioImage.getImageDescriptor("de.bmotionstudio.gef.editor", "icons/icon_chop.gif"));
                        } else {
                            action.setImageDescriptor(null);
                        }
                        handleObserverMenu.add(action);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private boolean checkIncludeObserver(String observerID, BControl control) {
        IExtensionPoint extensionPoint = this.registry.getExtensionPoint("de.bmotionstudio.gef.editor.includeObserver");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String langID;
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if ("include".equals(configurationElement.getName()) && (langID = configurationElement.getAttribute("language")) != null && langID.equals(control.getVisualization().getLanguage())) {
                    IConfigurationElement[] iConfigurationElementArray2 = configurationElement.getChildren("observer");
                    int n5 = iConfigurationElementArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IConfigurationElement cObserver = iConfigurationElementArray2[n6];
                        String oID = cObserver.getAttribute("id");
                        if (observerID.equals(oID)) {
                            IConfigurationElement[] iConfigurationElementArray3 = cObserver.getChildren("control");
                            int n7 = iConfigurationElementArray3.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                IConfigurationElement configBControl = iConfigurationElementArray3[n8];
                                String bID = configBControl.getAttribute("id");
                                if (control.getType().equals(bID)) {
                                    return true;
                                }
                                ++n8;
                            }
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    private void buildEventMenu(IMenuManager menu, AbstractEditPart editPart) {
        Object model = editPart.getModel();
        if (model instanceof BControl && !(model instanceof Visualization)) {
            MenuManager handleEventMenu = new MenuManager("Events", BMotionStudioImage.getImageDescriptor("de.bmotionstudio.gef.editor", "icons/icon_event.png"), "eventMenu");
            menu.appendToGroup("group.add", (IContributionItem)handleEventMenu);
            BControl bcontrol = (BControl)model;
            if (bcontrol.hasEvent(this.eventIDs[0]).booleanValue()) {
                SchedulerEvent event = bcontrol.getEvent(this.eventIDs[0]);
                OpenSchedulerEventAction action = (OpenSchedulerEventAction)this.getActionRegistry().getAction((Object)("de.bmotionstudio.gef.editor.SchedulerEventAction." + event.getID()));
                action.setEventID(this.eventIDs[0]);
                action.setText(event.getName());
                action.setImageDescriptor(BMotionStudioImage.getImageDescriptor("de.bmotionstudio.gef.editor", "icons/icon_chop.gif"));
                handleEventMenu.add((IAction)action);
            } else {
                IExtensionPoint schedulerExtensionPoint = this.registry.getExtensionPoint("de.bmotionstudio.gef.editor.schedulerEvent");
                IExtension[] iExtensionArray = schedulerExtensionPoint.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension schedulerExtension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = schedulerExtension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement configSchedulerElement = iConfigurationElementArray[n4];
                        if ("schedulerEvent".equals(configSchedulerElement.getName())) {
                            String sClassName = configSchedulerElement.getAttribute("class");
                            Boolean show = Boolean.valueOf(configSchedulerElement.getAttribute("menu"));
                            if (show.booleanValue()) {
                                OpenSchedulerEventAction action = (OpenSchedulerEventAction)this.getActionRegistry().getAction((Object)("de.bmotionstudio.gef.editor.SchedulerEventAction." + sClassName));
                                action.setEventID(this.eventIDs[0]);
                                action.setText(configSchedulerElement.getAttribute("name"));
                                action.setImageDescriptor(null);
                                handleEventMenu.add((IAction)action);
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
    }

    private ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    private void setActionRegistry(ActionRegistry registry) {
        this.actionRegistry = registry;
    }
}

